<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';
session_start();
?>

<div class="container my-5">
  <h2>📋 Übersicht aller Bestellungen</h2>
  <table class="table table-bordered table-hover">
    <thead class="table-dark">
      <tr>
        <th>#</th>
        <th>Benutzer</th>
        <th>Datum</th>
        <th>Status</th>
        <th>Artikel</th>
        <th>Details</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $sql = "SELECT b.id, u.vorname, u.nachname, b.datum, b.status,
              GROUP_CONCAT(CONCAT(p.artikelname, ' (', IFNULL(p.groesse, '-'), ') x', p.anzahl) SEPARATOR '<br>') AS artikel
              FROM bestellungen b
              JOIN users u ON b.user_id = u.id
              JOIN bestellpositionen p ON p.bestellung_id = b.id
              GROUP BY b.id ORDER BY b.datum DESC";
      $result = $conn->query($sql);
      while ($row = $result->fetch_assoc()):
      ?>
      <tr>
        <td><?= $row['id'] ?></td>
        <td><?= htmlspecialchars($row['vorname'] . ' ' . $row['nachname']) ?></td>
        <td><?= $row['datum'] ?></td>
        <td><?= $row['status'] ?></td>
        <td><?= $row['artikel'] ?></td>
        <td><a href="bestellung_detail.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-info">Anzeigen</a></td>
      </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>

<?php include 'includes/footer.php'; ?>
