<?php
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

// Zugriffsschutz (optional)
if (!isset($_SESSION['user_id'])) {
    echo "<div class='container mt-5'><div class='alert alert-danger'>Zugriff verweigert.</div></div>";
    include 'includes/footer.php';
    exit;
}

$einheit = $_SESSION['einheit'] ?? '';

$query = $conn->prepare("SELECT * FROM ffw_geraete WHERE status = 'ausgesondert' AND einheit = ?");
$query->bind_param("s", $einheit);
$query->execute();
$result = $query->get_result();
?>

<div class="container my-5">
  <h2 class="mb-4 text-danger">🗑️ Ausgesonderte Geräte (Papierkorb)</h2>

  <div class="table-responsive">
    <table class="table table-hover table-bordered bg-white">
      <thead class="table-danger text-dark">
        <tr>
          <th>Bezeichnung</th>
          <th>Barcode</th>
          <th>Fahrzeug</th>
          <th>Geräteraum</th>
          <th>Baujahr</th>
          <th>Letzte Prüfung</th>
          <th>Standort</th>
          <th>Notiz</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= htmlspecialchars($row['bezeichnung']) ?></td>
            <td><?= htmlspecialchars($row['barcode']) ?></td>
            <td><?= htmlspecialchars($row['fahrzeug']) ?></td>
            <td><?= htmlspecialchars($row['gr']) ?></td>
            <td><?= htmlspecialchars($row['baujahr']) ?></td>
            <td><?= date("d.m.Y", $row['lpruefung']) ?></td>
            <td><?= htmlspecialchars($row['standort']) ?></td>
            <td><?= nl2br(htmlspecialchars($row['memo'])) ?></td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
