<?php
include '../includes/header.php';
include '../includes/nav.php';
?>

<div class="container my-5">
  <h1 class="mb-4 text-center">🧯 Hilfe zur Atemschutzgeräte-Verwaltung</h1>

  <div class="accordion" id="atemschutzHelpAccordion">

    <!-- Einführung -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingIntro">
        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseIntro" aria-expanded="true">
          🔰 Einführung
        </button>
      </h2>
      <div id="collapseIntro" class="accordion-collapse collapse show" data-bs-parent="#atemschutzHelpAccordion">
        <div class="accordion-body">
          In der Atemschutzgeräte-Verwaltung kannst du alle Atemschutzgeräte deiner Einheit erfassen, Prüfungen dokumentieren und eine Prüfhistorie führen. Farbmarkierungen helfen dir, fällige Prüfungen frühzeitig zu erkennen.
        </div>
      </div>
    </div>

    <!-- Gerät hinzufügen -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingAdd">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdd">
          ➕ Neues Gerät hinzufügen
        </button>
      </h2>
      <div id="collapseAdd" class="accordion-collapse collapse" data-bs-parent="#atemschutzHelpAccordion">
        <div class="accordion-body">
          <ol>
            <li>Gib im Abschnitt <strong>„Neues Atemschutzgerät hinzufügen“</strong> den Gerätenamen und die Seriennummer ein</li>
            <li>Klicke auf <strong>„Hinzufügen“</strong></li>
          </ol>
          Das Gerät wird automatisch mit dem heutigen Datum als letzte Prüfung sowie einer nächsten Prüfung in 30 Tagen gespeichert.
        </div>
      </div>
    </div>

    <!-- Gerät prüfen -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingCheck">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseCheck">
          ✅ Gerät als geprüft markieren
        </button>
      </h2>
      <div id="collapseCheck" class="accordion-collapse collapse" data-bs-parent="#atemschutzHelpAccordion">
        <div class="accordion-body">
          <ol>
            <li>Klicke in der Gerätetabelle auf den Button <strong>„Geprüft“</strong></li>
            <li>Bestätige die Sicherheitsabfrage</li>
            <li>Das Gerät wird mit deinem Namen, aktuellem Datum und neuer Frist gespeichert</li>
          </ol>
          Zusätzlich wird ein Eintrag in der Prüfhistorie angelegt.
        </div>
      </div>
    </div>

    <!-- Historie einsehen -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingHistory">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseHistory">
          📖 Prüfhistorie einsehen
        </button>
      </h2>
      <div id="collapseHistory" class="accordion-collapse collapse" data-bs-parent="#atemschutzHelpAccordion">
        <div class="accordion-body">
          <ol>
            <li>Klicke bei einem Gerät auf <strong>„Historie“</strong></li>
            <li>Du siehst alle bisherigen Prüfungen mit Datum und Prüfer</li>
          </ol>
        </div>
      </div>
    </div>

    <!-- Farben & Prüfstatus -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingColors">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseColors">
          🎨 Farbige Prüfstatus-Anzeige
        </button>
      </h2>
      <div id="collapseColors" class="accordion-collapse collapse" data-bs-parent="#atemschutzHelpAccordion">
        <div class="accordion-body">
          Die Tabelle zeigt anhand von Farben an, wann eine Prüfung fällig ist:
          <ul>
            <li><span class="badge bg-danger">Rot</span> = Prüfung fällig in ≤ 3 Tagen</li>
            <li><span class="badge bg-warning text-dark">Gelb</span> = Prüfung fällig in ≤ 7 Tagen</li>
            <li><span class="badge bg-success">Grün</span> = Prüfung in Ordnung</li>
          </ul>
        </div>
      </div>
    </div>

    <!-- Tipps -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingTips">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTips">
          💡 Tipps & Hinweise
        </button>
      </h2>
      <div id="collapseTips" class="accordion-collapse collapse" data-bs-parent="#atemschutzHelpAccordion">
        <div class="accordion-body">
          <ul>
            <li>Prüfe regelmäßig deine Übersicht – farbige Felder helfen bei der Planung</li>
            <li>Nutze das Suchfeld für große Listen – Seriennummer oder Gerätebezeichnung</li>
            <li>Jede Prüfung wird historisch gespeichert – ideal für Nachweise und Berichte</li>
          </ul>
        </div>
      </div>
    </div>

    <!-- Kontakt -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingSupport">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSupport">
          📞 Support kontaktieren
        </button>
      </h2>
      <div id="collapseSupport" class="accordion-collapse collapse" data-bs-parent="#atemschutzHelpAccordion">
        <div class="accordion-body">
          Wenn du Fragen hast oder technische Probleme auftreten:<br>
          <a href="mailto:support@f-invent.de">support@f-invent.de</a><br>
          oder nutze das <a href="../feedback.php">Feedback-Formular</a>.
        </div>
      </div>
    </div>

  </div>
</div>

<?php include '../includes/footer.php'; ?>
