<?php
// Annahme: $conn (DB) und Ticketdaten wie $name, $fachbereich usw. sind bereits gesetzt

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
include_once __DIR__ . '/PHPMailer/PHProcksAutoloader.php';


// Nachricht als Textblock für AltBody und HTML-Pre
$nachricht = "Ein neues Ticket wurde erfolgreich erstellt:\n\n";
$nachricht .= sprintf("%-15s %-35s\n", "Feld", "Wert");
$nachricht .= str_repeat("-", 50) . "\n";
$nachricht .= sprintf("%-15s %-35s\n", "Ticketnummer:", $ticketnummer);
$nachricht .= sprintf("%-15s %-35s\n", "Erstellt am:", $erstellt);
$nachricht .= sprintf("%-15s %-35s\n", "Name:", $name);
$nachricht .= sprintf("%-15s %-35s\n", "E-Mail:", $email);
$nachricht .= sprintf("%-15s %-35s\n", "Spindnummer:", $spindnr);
$nachricht .= sprintf("%-15s %-35s\n", "Fachbereich:", $fachbereich);
$nachricht .= sprintf("%-15s %-35s\n", "Beschreibung:", $beschreibung);

$nachricht_html = "<pre>" . htmlspecialchars($nachricht) . "</pre>";

// HTML-Mail
$html = <<<HTML
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      padding: 20px;
    }
    .container {
      max-width: 900px;
      margin: 0 auto;
      background: #ffffff;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    .header {
      background: #0d6efd;
      color: #fff;
      padding: 15px;
      font-size: 20px;
      font-weight: bold;
      text-align: center;
      border-radius: 10px 10px 0 0;
    }
    .content {
      padding: 20px;
      font-size: 16px;
      color: #333;
    }
    pre {
      background: #f8f9fa;
      padding: 10px;
      border-radius: 6px;
      font-family: monospace;
      overflow-x: auto;
      white-space: pre;
      width: 100%;
      display: block;
    }
    .footer {
      margin-top: 20px;
      font-size: 14px;
      color: #888;
      text-align: center;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">Ticket erstellt</div>
    <div class="content">
      <p>Moin,</p>
      <p>folgendes Ticket wurde erfolgreich im System erstellt:</p>
      {$nachricht_html}
      <br>
      <p>Mit kameradschaftlichen Grüßen</p>
    </div>
    <div class="footer">&copy; app.f-invent.de</div>
  </div>
</body>
</html>
HTML;

// Mail versenden
$oMailer = new PHPMailer;
$oMailer->CharSet = 'UTF-8';
$oMailer->isSMTP();
$oMailer->Host = 'mail.f-invent.de';
$oMailer->SMTPAuth = true;
$oMailer->Username = 'noreply@f-invent.de';
$oMailer->Password = 'b*Y!@Ys.aKS^';
$oMailer->SMTPSecure = 'tls';
$oMailer->Port = 587;

$oMailer->From = 'noreply@f-invent.de';
$oMailer->FromName = 'app.F-Invent.de';
$oMailer->addAddress($email); // Kunde
$oMailer->addBCC('ticketsystem@app.f-invent.de'); // Intern
$oMailer->addBCC('geraeteverwaltung@feuerwehr-bad-zwischenahn.de'); // Intern
//$oMailer->addBCC('a602411a.ofv112.onmicrosoft.com@de.teams.ms'); // Intern
$oMailer->addReplyTo('ticketsystem@app.f-invent.de');

$oMailer->isHTML(true);
$oMailer->Subject = "🎫 Ticket {$ticketnummer}";
$oMailer->Body    = $html;
$oMailer->AltBody = strip_tags($nachricht);

if (!$oMailer->send()) {
    echo '❌ Fehler beim Versand der Ticket-E-Mail!';
} else {
    echo '✅ Ticket wurde erstellt und per Mail bestätigt.';
}
?>
