<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

// Zugriffsschutz
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$id = (int)($_GET['id'] ?? 0);
$meldung = '';

// --- Formular speichern, falls ausgefüllt ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['buchung_speichern']) && isset($_POST['artikel_id'])) {
    $id = (int)$_POST['artikel_id'];

    $buchungstyp = $_POST['buchungstyp'];
    $anzahl = (int)$_POST['anzahl'];
    $kamerad_id = $_POST['kamerad_id'] !== '' ? (int)$_POST['kamerad_id'] : NULL;
    $bemerkung = trim($_POST['bemerkung']);

    if ($anzahl > 0 && $id > 0) {
        $bestand_sql = ($buchungstyp === 'Zugang') ?
            "UPDATE lager_bestand SET bestand = bestand + ? WHERE id = ?" :
            "UPDATE lager_bestand SET bestand = bestand - ? WHERE id = ?";

        $stmt = $conn->prepare($bestand_sql);
        $stmt->bind_param("ii", $anzahl, $id);
        $stmt->execute();

        $stmt_hist = $conn->prepare("INSERT INTO lager_historie (lager_id, buchungstyp, anzahl, kamerad_id, bemerkung) VALUES (?, ?, ?, ?, ?)");
        $stmt_hist->bind_param("issis", $id, $buchungstyp, $anzahl, $kamerad_id, $bemerkung);
        $stmt_hist->execute();

        $meldung = "<div class='alert alert-success'>Buchung erfolgreich gespeichert.</div>";

        // Nach Buchung zurück zur Suche
        $id = 0;
    } else {
        $meldung = "<div class='alert alert-danger'>Ungültige Eingaben.</div>";
    }
}

?>

<div class="container my-5">
  <h2 class="mb-4">Lager - Buchen</h2>

  <?= $meldung ?>

  <?php if ($id === 0): ?>

    <!-- Artikelsuche -->
    <div class="card p-4 bg-white shadow-sm">
      <div class="mb-3">
        <label class="form-label">Artikelsuche</label>
        <input type="text" id="artikelSuchfeld" class="form-control" placeholder="Artikelnummer oder Name eingeben...">
      </div>

      <ul class="list-group" id="suchErgebnisse" style="display:none;"></ul>

      <div class="mt-4">
        <a href="lager.php" class="btn btn-secondary">&laquo; Zurück</a>
      </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
      const suchfeld = document.getElementById('artikelSuchfeld');
      const ergebnisListe = document.getElementById('suchErgebnisse');

      suchfeld.addEventListener('input', function() {
        const suchbegriff = suchfeld.value.trim();

        if (suchbegriff.length < 2) {
          ergebnisListe.style.display = 'none';
          ergebnisListe.innerHTML = '';
          return;
        }

        fetch('lager_suche.php?s=' + encodeURIComponent(suchbegriff))
          .then(response => response.json())
          .then(daten => {
            ergebnisListe.innerHTML = '';

            if (daten.length > 0) {
              daten.forEach(artikel => {
                const li = document.createElement('li');
                li.classList.add('list-group-item', 'list-group-item-action');
                li.textContent = artikel.artikelnummer + ' - ' + artikel.artikelname;
                li.onclick = function() {
                  window.location.href = 'lager_buchung.php?id=' + artikel.id;
                };
                ergebnisListe.appendChild(li);
              });
              ergebnisListe.style.display = 'block';
            } else {
              ergebnisListe.style.display = 'none';
            }
          });
      });
    });
    </script>

  <?php else: ?>

    <!-- Buchungsformular -->
    <?php
    $stmt = $conn->prepare("SELECT * FROM lager_bestand WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $artikel = $stmt->get_result()->fetch_assoc();

    if (!$artikel) {
        echo "<div class='alert alert-danger'>Artikel nicht gefunden.</div>";
    } else {
        $kameraden = $conn->query("SELECT id, vorname, nachname FROM kameraden ORDER BY nachname ASC");
    ?>

    <div class="card p-4 bg-white shadow-sm">
      <h4 class="mb-4">Buchung für: <?= htmlspecialchars($artikel['artikelnummer']) ?> - <?= htmlspecialchars($artikel['artikelname']) ?></h4>

      <form method="post">
        <input type="hidden" name="artikel_id" value="<?= $id ?>">

        <div class="mb-3">
          <label class="form-label">Buchungstyp</label>
          <select name="buchungstyp" class="form-select" required>
            <option value="Zugang">Zugang (+)</option>
            <option value="Abgang">Abgang (-)</option>
          </select>
        </div>

        <div class="mb-3">
          <label class="form-label">Anzahl</label>
          <input type="number" name="anzahl" class="form-control" min="1" required>
        </div>

        <div class="mb-3">
          <label class="form-label">Kamerad (optional)</label>
          <select name="kamerad_id" class="form-select">
            <option value="">- Keine Auswahl -</option>
            <?php while ($k = $kameraden->fetch_assoc()): ?>
              <option value="<?= $k['id'] ?>"><?= htmlspecialchars($k['vorname'] . ' ' . $k['nachname']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>

        <div class="mb-3">
          <label class="form-label">Bemerkung (optional)</label>
          <textarea name="bemerkung" class="form-control"></textarea>
        </div>

        <div class="d-flex gap-2">
          <button type="submit" name="buchung_speichern" class="btn btn-primary">Buchung speichern</button>
          <a href="lager_buchung.php" class="btn btn-secondary">Anderen Artikel buchen</a>
        </div>
      </form>
    </div>

    <?php } ?>

  <?php endif; ?>

</div>

<?php include 'includes/footer.php'; ?>
