<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

// Zugriffsschutz
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// --- Daten sammeln ---

// Gesamtanzahl Dienstbekleidung
$stmt = $conn->prepare("SELECT COUNT(*) as anzahl FROM lager_bestand WHERE kategorie = 'Dienstbekleidung'");
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();
$gesamt_db = $res['anzahl'] ?? 0;

// Artikel unter Mindestbestand
$stmt = $conn->prepare("SELECT COUNT(*) as kritisch FROM lager_bestand WHERE kategorie = 'Dienstbekleidung' AND bestand <= mindesbestand");
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();
$kritisch_db = $res['kritisch'] ?? 0;

// Größen-Verteilung
$stmt = $conn->prepare("SELECT groesse, COUNT(*) as anzahl FROM lager_bestand WHERE kategorie = 'Dienstbekleidung' GROUP BY groesse ORDER BY groesse ASC");
$stmt->execute();
$groessen = $stmt->get_result();

// Einzelne kritische Artikel
$stmt = $conn->prepare("SELECT artikelnummer, artikelname, bestand FROM lager_bestand WHERE kategorie = 'Dienstbekleidung' AND bestand <= mindesbestand ORDER BY bestand ASC");
$stmt->execute();
$kritische_artikel = $stmt->get_result();
?>

<div class="container my-5">
  <h2 class="mb-4">Dashboard - Dienstbekleidung</h2>

  <div class="row g-4">
    <div class="col-md-4">
      <div class="card text-white bg-primary h-100">
        <div class="card-body">
          <h5 class="card-title">Gesamtartikel</h5>
          <p class="card-text display-6"><?= $gesamt_db ?></p>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card text-white bg-danger h-100">
        <div class="card-body">
          <h5 class="card-title">Kritische Bestände</h5>
          <p class="card-text display-6"><?= $kritisch_db ?></p>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card text-white bg-success h-100">
        <div class="card-body">
          <h5 class="card-title">Aktionen</h5>
          <a href="lager.php" class="btn btn-light btn-sm w-100 mb-2">Lagerbestand ansehen</a>
          <a href="lager_buchung.php" class="btn btn-light btn-sm w-100 mb-2">Neue Buchung</a>
          <a href="lager_historie.php" class="btn btn-light btn-sm w-100">Historie</a>
        </div>
      </div>
    </div>
  </div>

  <hr class="my-5">

  <h3 class="mb-3">Größenverteilung (Dienstbekleidung)</h3>
  <canvas id="groessenChart" height="100"></canvas>

  <hr class="my-5">

  <h3 class="mb-3">Artikel unter Mindestbestand</h3>

  <?php if ($kritische_artikel->num_rows > 0): ?>
    <div class="table-responsive">
      <table class="table table-bordered table-hover bg-white">
        <thead class="table-light">
          <tr>
            <th>Artikelnummer</th>
            <th>Name</th>
            <th>Bestand</th>
          </tr>
        </thead>
        <tbody>
          <?php while ($row = $kritische_artikel->fetch_assoc()): ?>
            <tr class="table-danger">
              <td><?= htmlspecialchars($row['artikelnummer']) ?></td>
              <td><?= htmlspecialchars($row['artikelname']) ?></td>
              <td><?= $row['bestand'] ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  <?php else: ?>
    <p class="text-muted">Keine kritischen Artikel.</p>
  <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>

<!-- Chart.js für Diagramm laden -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  const ctx = document.getElementById('groessenChart').getContext('2d');

  const chart = new Chart(ctx, {
    type: 'bar',
    data: {
      labels: [
        <?php
        $stmt = $conn->prepare("SELECT groesse FROM lager_bestand WHERE kategorie = 'Dienstbekleidung' GROUP BY groesse ORDER BY groesse ASC");
        $stmt->execute();
        $groessen = $stmt->get_result();
        while ($row = $groessen->fetch_assoc()) {
          echo "'" . htmlspecialchars($row['groesse']) . "',";
        }
        ?>
      ],
      datasets: [{
        label: 'Anzahl',
        data: [
          <?php
          $stmt = $conn->prepare("SELECT COUNT(*) as anzahl FROM lager_bestand WHERE kategorie = 'Dienstbekleidung' GROUP BY groesse ORDER BY groesse ASC");
          $stmt->execute();
          $groessen = $stmt->get_result();
          while ($row = $groessen->fetch_assoc()) {
            echo $row['anzahl'] . ",";
          }
          ?>
        ],
        backgroundColor: 'rgba(75, 192, 192, 0.7)'
      }]
    },
    options: {
      scales: {
        y: {
          beginAtZero: true,
          precision: 0
        }
      }
    }
  });
});
</script>
