<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

$meldung = '';

// Kameraden hinzufügen, wenn Modal abgeschickt wird
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_kamerad'])) {
    $vorname = trim($_POST['vorname']);
    $nachname = trim($_POST['nachname']);
    $email = trim($_POST['email']);
    $spindnr = trim($_POST['spindnr']);

    if ($vorname && $nachname && $spindnr) {
        // Prüfen, ob Spindnummer schon vergeben ist
        $stmt_check = $conn->prepare("SELECT id FROM kameraden WHERE spindnr = ?");
        $stmt_check->bind_param("s", $spindnr);
        $stmt_check->execute();
        $check_result = $stmt_check->get_result();

        if ($check_result->num_rows > 0) {
            $meldung = "<div class='alert alert-danger'>Fehler: Spindnummer bereits vergeben!</div>";
        } else {
            // Spind frei, Kamerad speichern
            $stmt = $conn->prepare("INSERT INTO kameraden (vorname, nachname, email, spindnr) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssss", $vorname, $nachname, $email, $spindnr);
            if ($stmt->execute()) {
                $meldung = "<div class='alert alert-success'>Kamerad erfolgreich hinzugefügt.</div>";
            } else {
                $meldung = "<div class='alert alert-danger'>Fehler beim Speichern.</div>";
            }
        }
    } else {
        $meldung = "<div class='alert alert-warning'>Bitte Vorname, Nachname und Spindnummer ausfüllen.</div>";
    }
}

// Kameraden abrufen
$kameraden = $conn->query("SELECT * FROM kameraden ORDER BY nachname ASC");
?>

<div class="container my-5">
  <h2 class="mb-4">Kameraden-Verwaltung</h2>

  <?= $meldung ?>

  <!-- Button Modal öffnen -->
  <button type="button" class="btn btn-primary mb-4" data-bs-toggle="modal" data-bs-target="#kameradModal">
    + Neuen Kameraden hinzufügen
  </button>

  <!-- Modal -->
  <div class="modal fade" id="kameradModal" tabindex="-1" aria-labelledby="kameradModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <form method="post" class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="kameradModalLabel">Neuen Kameraden hinzufügen</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Schließen"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Vorname</label>
            <input type="text" name="vorname" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Nachname</label>
            <input type="text" name="nachname" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">E-Mail (optional)</label>
            <input type="email" name="email" class="form-control">
          </div>
          <div class="mb-3">
            <label class="form-label">Spindnummer</label>
            <input type="text" name="spindnr" class="form-control" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
          <button type="submit" name="new_kamerad" class="btn btn-primary">Speichern</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Tabelle -->
  <div class="table-responsive">
    <table class="table table-bordered table-hover bg-white">
      <thead class="table-dark">
        <tr>
          <th>Vorname</th>
          <th>Nachname</th>
          <th>E-Mail</th>
          <th>Spindnummer</th>
          <th>Aktion</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($k = $kameraden->fetch_assoc()): ?>
          <tr>
            <td><?= htmlspecialchars($k['vorname']) ?></td>
            <td><?= htmlspecialchars($k['nachname']) ?></td>
            <td><?= htmlspecialchars($k['email']) ?></td>
            <td><?= htmlspecialchars($k['spindnr']) ?></td>
            <td>
              <a href="kamerad_edit.php?id=<?= $k['id'] ?>" class="btn btn-sm btn-outline-primary">Bearbeiten</a>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
