<?php
require_once '../includes/db.php';

$sql = "SELECT artikelnummer, artikelname, bestand, mindesbestand
        FROM lager_bestand
        WHERE bestand <= mindesbestand";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    // E-Mail-Inhalt vorbereiten
    $nachricht = "⚠️ Die folgenden Artikel haben den Mindestbestand unterschritten:\n\n";
    $nachricht .= sprintf("");

    while ($row = $result->fetch_assoc()) {
        $nachricht .= sprintf(
            "%-15s %-35s %10s %10s\n",
            $row['artikelnummer'],
            mb_strimwidth($row['artikelname'], 0, 34, "..."),
            $row['bestand'],
            $row['mindesbestand']
        );
    }


}

$conn->close();
