<?php
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Daten aus der users-Tabelle laden
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
?>

<div class="container mt-5">
    <h1 class="mb-4">👤 Mein Benutzerkonto</h1>

    <?php if ($user): ?>
        <table class="table table-bordered w-100">
            <tr><th>Benutzername</th><td><?= htmlspecialchars($user['username']) ?></td></tr>
            <tr><th>Vorname</th><td><?= htmlspecialchars($user['vorname']) ?></td></tr>
            <tr><th>Nachname</th><td><?= htmlspecialchars($user['nachname']) ?></td></tr>
            <tr><th>E-Mail</th><td><?= htmlspecialchars($user['email']) ?></td></tr>
            <tr><th>Einheit</th><td><?= htmlspecialchars($user['einheit']) ?></td></tr>
            <tr><th>Gemeinde-ID</th><td><?= htmlspecialchars($user['gemeinde_id']) ?></td></tr>
            <tr><th>Rolle</th><td><?= htmlspecialchars($user['rolle']) ?></td></tr>
        </table>

        <!-- Optional Buttons -->
        <div class="mt-4">
            <a href="account_edit.php" class="btn btn-primary me-2">✏️ Bearbeiten</a>
            <a href="passwort_aendern.php" class="btn btn-outline-secondary">🔒 Passwort ändern</a>
        </div>

    <?php else: ?>
        <div class="alert alert-danger">Benutzer nicht gefunden.</div>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
