<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$einheit = $_SESSION['einheit'] ?? '';

// Balkendiagramm: Geräteanzahl je Kategorie
$stmt = $conn->prepare("SELECT kat, COUNT(*) as anzahl FROM ffw_geraete WHERE einheit = ? GROUP BY kat ORDER BY anzahl DESC");
$stmt->bind_param("s", $einheit);
$stmt->execute();
$kat_data = $stmt->get_result();
$kategorien = [];
$anzahlen = [];
while ($row = $kat_data->fetch_assoc()) {
    $kategorien[] = $row['kat'];
    $anzahlen[] = (int)$row['anzahl'];
}

// Heatmap: Verteilung je Kategorie und Geräteraum
$stmt = $conn->prepare("SELECT gr, kat, COUNT(*) as anzahl FROM ffw_geraete WHERE einheit = ? GROUP BY gr, kat");
$stmt->bind_param("s", $einheit);
$stmt->execute();
$heat_result = $stmt->get_result();
$heatmap = [];
while ($row = $heat_result->fetch_assoc()) {
    $gr = $row['gr'];
    $kat = $row['kat'];
    $heatmap[$gr][$kat] = (int)$row['anzahl'];
}
$geraeteraeume = array_keys($heatmap);
$alle_kategorien = [];
foreach ($heatmap as $werte) {
    $alle_kategorien = array_unique(array_merge($alle_kategorien, array_keys($werte)));
}
sort($alle_kategorien);

// Dropdown-Auswahl
$stmt = $conn->prepare("SELECT DISTINCT kat FROM ffw_geraete WHERE einheit = ? ORDER BY kat");
$stmt->bind_param("s", $einheit);
$stmt->execute();
$kat_result = $stmt->get_result();
$dropdown_kategorien = [];
while ($row = $kat_result->fetch_assoc()) {
    $dropdown_kategorien[] = $row['kat'];
}

$gewaehlt = $_GET['kategorie'] ?? '';
$geraete = [];
if (!empty($gewaehlt)) {
    $stmt = $conn->prepare("SELECT * FROM ffw_geraete WHERE kat = ? AND einheit = ? ORDER BY barcode");
    $stmt->bind_param("ss", $gewaehlt, $einheit);
    $stmt->execute();
    $geraete = $stmt->get_result();
}

// Fahrzeugnamen zu den Barcodes laden (nur eigene Einheit)
$fahrzeug_map = [];
$stmt = $conn->prepare("SELECT barcode_fzg, fahrzeugbezeichnung FROM ffw_fahrzeuge WHERE einheit = ?");
$stmt->bind_param("s", $einheit);
$stmt->execute();
$fahrz_query = $stmt->get_result();
while ($fz = $fahrz_query->fetch_assoc()) {
    $fahrzeug_map[$fz['barcode_fzg']] = $fz['fahrzeugbezeichnung'];
}
?>

<div class="container my-5">
  <h2 class="mb-4">Gerätestatistik</h2>

  <!-- Diagramm -->
  <canvas id="barChart" height="80"></canvas>

  <!-- Heatmap-Tabelle -->
  <h4 class="mt-5 mb-3">Gerätekategorien nach Geräteraum</h4>
  <div class="table-responsive">
    <table class="table table-bordered bg-white align-middle text-center">
      <thead class="table-dark">
        <tr>
          <th>Geräteraum</th>
          <?php foreach ($alle_kategorien as $k): ?>
            <th><?= htmlspecialchars($k) ?></th>
          <?php endforeach; ?>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($geraeteraeume as $raum): ?>
          <tr>
            <td><?= htmlspecialchars($raum) ?></td>
            <?php foreach ($alle_kategorien as $k): ?>
              <td><?= $heatmap[$raum][$k] ?? 0 ?></td>
            <?php endforeach; ?>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <!-- Dropdown -->
  <h4 class="mt-5">Geräte nach Kategorie anzeigen</h4>
  <form method="get" class="mb-4">
    <label class="form-label">Kategorie auswählen</label>
    <div class="input-group">
      <select name="kategorie" class="form-select" onchange="this.form.submit()">
        <option value="">-- Kategorie wählen --</option>
        <?php foreach ($dropdown_kategorien as $kat): ?>
          <option value="<?= htmlspecialchars($kat) ?>" <?= $gewaehlt === $kat ? 'selected' : '' ?>>
            <?= htmlspecialchars($kat) ?>
          </option>
        <?php endforeach; ?>
      </select>
      <button type="submit" class="btn btn-primary">Anzeigen</button>
    </div>
  </form>

  <!-- Tabelle Geräte -->
  <?php if (!empty($gewaehlt) && $geraete): ?>
    <h4 class="mb-3">Geräte in der Kategorie: <?= htmlspecialchars($gewaehlt) ?></h4>
    <div class="table-responsive">
      <table class="table table-bordered bg-white">
        <thead class="table-dark">
          <tr>
            <th>Bezeichnung</th>
            <th>Geräteraum</th>
            <th>Fahrzeug</th>
            <th>Letzte Prüfung</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php while ($g = $geraete->fetch_assoc()): ?>
            <tr>
              <td><?= htmlspecialchars($g['bezeichnung']) ?></td>
              <td><?= htmlspecialchars($g['gr']) ?></td>
              <td><?= isset($fahrzeug_map[$g['fahrzeug']]) ? htmlspecialchars($fahrzeug_map[$g['fahrzeug']]) : htmlspecialchars($g['fahrzeug']) ?></td>
              <td><?= is_numeric($g['lpruefung']) && $g['lpruefung'] > 0 ? date('d.m.Y', $g['lpruefung']) : '-' ?></td>
              <td><?= htmlspecialchars($g['status']) ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('barChart').getContext('2d');
const barChart = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: <?= json_encode($kategorien) ?>,
        datasets: [{
            label: 'Geräteanzahl pro Kategorie',
            data: <?= json_encode($anzahlen) ?>,
            backgroundColor: 'rgba(54, 162, 235, 0.7)'
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true,
                ticks: { stepSize: 1 }
            }
        }
    }
});
</script>

<?php include 'includes/footer.php'; ?>
