<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Daten holen
$total_melder = $conn->query("SELECT COUNT(*) AS anzahl FROM melder")->fetch_assoc()['anzahl'];
$mit_ladegeraet = $conn->query("SELECT COUNT(*) AS anzahl FROM melder WHERE ladegeraet = 1")->fetch_assoc()['anzahl'];
$mit_antenne = $conn->query("SELECT COUNT(*) AS anzahl FROM melder WHERE antenne = 1")->fetch_assoc()['anzahl'];
$mit_schutztasche = $conn->query("SELECT COUNT(*) AS anzahl FROM melder WHERE schutztasche = 1")->fetch_assoc()['anzahl'];

// Letzte Melder
$letzte_melder = $conn->query("SELECT * FROM melder ORDER BY id DESC LIMIT 5");
?>

<div class="container my-5">
  <h2 class="mb-4">Dashboard - Meldeempfänger</h2>

  <div class="row g-4 mb-5">
    <div class="col-md-3">
      <div class="card text-white bg-primary">
        <div class="card-body">
          <h5 class="card-title">Gesamt</h5>
          <p class="card-text fs-4"><?= $total_melder ?></p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card text-white bg-success">
        <div class="card-body">
          <h5 class="card-title">mit Ladegerät</h5>
          <p class="card-text fs-4"><?= $mit_ladegeraet ?></p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card text-white bg-warning">
        <div class="card-body">
          <h5 class="card-title">mit Antenne</h5>
          <p class="card-text fs-4"><?= $mit_antenne ?></p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card text-white bg-info">
        <div class="card-body">
          <h5 class="card-title">mit Schutztasche</h5>
          <p class="card-text fs-4"><?= $mit_schutztasche ?></p>
        </div>
      </div>
    </div>
  </div>

  <div class="card p-4 mb-5">
    <h4 class="mb-4">Letzte 5 hinzugefügte Melder</h4>
    <div class="table-responsive">
      <table class="table table-bordered">
        <thead class="table-dark">
          <tr>
            <th>Seriennummer</th>
            <th>Typ</th>
            <th>Kennung</th>
            <th>Ausgabe-Datum</th>
          </tr>
        </thead>
        <tbody>
          <?php while ($m = $letzte_melder->fetch_assoc()): ?>
            <tr>
              <td><?= htmlspecialchars($m['seriennummer']) ?></td>
              <td><?= htmlspecialchars($m['typ']) ?></td>
              <td><?= htmlspecialchars($m['kennung']) ?></td>
              <td><?= $m['ausgabe_datum'] ? date('d.m.Y', strtotime($m['ausgabe_datum'])) : '-' ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="d-flex justify-content-between">
    <a href="melder.php" class="btn btn-primary">Melder verwalten</a>
    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#melderModal">Neuen Melder hinzufügen</button>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
