<?php
include 'includes/db.php';
session_start();

$id = intval($_GET['id']);
$meldung = '';

// Info + Status speichern
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['info_speichern'])) {
    $info = trim($_POST['info']);
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE bestellungen SET info = ?, status = ? WHERE id = ?");
    $stmt->bind_param("ssi", $info, $status, $id);
    $stmt->execute();

    $meldung = "<div class='alert alert-success'>✅ Info & Status gespeichert.</div>";
}

// Daten laden
$sql = "SELECT b.*, u.vorname, u.nachname FROM bestellungen b JOIN users u ON b.user_id = u.id WHERE b.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$bestellung = $result->fetch_assoc();

$artikel = $conn->query("SELECT * FROM bestellpositionen WHERE bestellung_id = $id");

// Status-Badge-Farbe definieren
function statusBadge($status) {
    switch ($status) {
        case 'bestellt':
            return '<span class="badge bg-success">✅ bestellt</span>';
        case 'erstellt':
        default:
            return '<span class="badge bg-secondary">📝 erstellt</span>';
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Bestellung #<?= $id ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; }
    .card { max-width: 700px; margin: 3rem auto; }
  </style>
</head>
<body>
  <div class="card shadow">
    <div class="card-body">
      <h3 class="card-title mb-3">🔍 Bestellung #<?= $id ?></h3>
      <?= $meldung ?>
      <p><strong>Von:</strong> <?= htmlspecialchars($bestellung['vorname'] . ' ' . $bestellung['nachname']) ?></p>
      <p><strong>Datum:</strong> <?= $bestellung['datum'] ?></p>
      <p><strong>Status:</strong> <?= statusBadge($bestellung['status']) ?></p>

      <h5 class="mt-4">🧾 Artikel</h5>
      <ul class="list-group mb-3">
        <?php while ($row = $artikel->fetch_assoc()): ?>
          <li class="list-group-item">
            <?= htmlspecialchars($row['artikelname']) ?> (<?= htmlspecialchars($row['groesse'] ?: '-') ?>) x<?= $row['anzahl'] ?>
          </li>
        <?php endwhile; ?>
      </ul>

      <form method="post">
        <h5 class="mt-4">📝 Info zur Bestellung</h5>
        <textarea name="info" class="form-control mb-3" rows="4" placeholder="Kommentar oder Anmerkung ..."><?= htmlspecialchars($bestellung['info']) ?></textarea>

        <h5 class="mt-4">📦 Status ändern</h5>
        <select name="status" class="form-select mb-3">
          <option value="erstellt" <?= $bestellung['status'] === 'erstellt' ? 'selected' : '' ?>>📝 erstellt</option>
          <option value="bestellt" <?= $bestellung['status'] === 'bestellt' ? 'selected' : '' ?>>✅ bestellt</option>
        </select>

        <button type="submit" name="info_speichern" class="btn btn-primary w-100">💾 Speichern</button>
      </form>
    </div>
  </div>
</body>
</html>
