<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

$meldung = '';
$einheit = $_SESSION['einheit'] ?? '';

// Melder hinzufügen
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['melder_hinzufuegen'])) {
    $seriennummer = trim($_POST['seriennummer']);
    $typ = trim($_POST['typ']);
    $kennung = trim($_POST['kennung']);
    $ausgabe_datum = !empty($_POST['ausgabe_datum']) ? $_POST['ausgabe_datum'] : NULL;
    $ladegeraet = isset($_POST['ladegeraet']) ? 1 : 0;
    $antenne = isset($_POST['antenne']) ? 1 : 0;
    $schutztasche = isset($_POST['schutztasche']) ? 1 : 0;
    $kamerad_id = !empty($_POST['kamerad_id']) ? (int)$_POST['kamerad_id'] : NULL;

    $stmt_check = $conn->prepare("SELECT id FROM melder WHERE kennung = ?");
    $stmt_check->bind_param("s", $kennung);
    $stmt_check->execute();
    $stmt_check->store_result();

    if ($stmt_check->num_rows > 0) {
        $meldung = "<div class='alert alert-danger'>Fehler: Die Kennung <strong>$kennung</strong> existiert bereits!</div>";
    } elseif ($seriennummer !== '' && $typ !== '') {
        $stmt = $conn->prepare("INSERT INTO melder (seriennummer, typ, kennung, ausgabe_datum, ladegeraet, antenne, schutztasche, kamerad_id, einheit)
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssiiiis", $seriennummer, $typ, $kennung, $ausgabe_datum, $ladegeraet, $antenne, $schutztasche, $kamerad_id, $einheit);
        $stmt->execute();
        $meldung = "<div class='alert alert-success'>Melder erfolgreich hinzugefügt.</div>";
    } else {
        $meldung = "<div class='alert alert-danger'>Bitte Seriennummer und Typ angeben!</div>";
    }
}

// CSV Export
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    $filename = 'melder_export_' . date('Y-m-d') . '.csv';
    header('Content-Type: text/csv; charset=utf-8');
    header("Content-Disposition: attachment; filename=\"$filename\"");
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Kennung', 'Typ', 'Seriennummer', 'Kamerad', 'Ausgabe-Datum', 'Zubehör', 'Einheit']);

    $result = $conn->query("SELECT m.*, k.vorname, k.nachname FROM melder m
                            LEFT JOIN kameraden k ON m.kamerad_id = k.id
                            ORDER BY m.id DESC");
    while ($row = $result->fetch_assoc()) {
        $kamerad = $row['vorname'] ? $row['vorname'] . ' ' . $row['nachname'] : '-';
        $zubehoer = ($row['ladegeraet'] ? 'Ladegerät ' : '') .
                    ($row['antenne'] ? 'Antenne ' : '') .
                    ($row['schutztasche'] ? 'Schutztasche' : '');
        fputcsv($output, [
            $row['kennung'],
            $row['typ'],
            $row['seriennummer'],
            $kamerad,
            $row['ausgabe_datum'] ? date('d.m.Y', strtotime($row['ausgabe_datum'])) : '',
            $zubehoer,
            $row['einheit']
        ]);
    }
    fclose($output);
    exit;
}

// Suche
$suchbegriff = $_GET['suche'] ?? '';
$where = '';
if (!empty($suchbegriff)) {
    $suchbegriff = "%$suchbegriff%";
    $where = "WHERE seriennummer LIKE ? OR typ LIKE ? OR kennung LIKE ?";
}

// Melder abrufen
if ($where) {
    $stmt = $conn->prepare("SELECT m.*, k.vorname, k.nachname FROM melder m
                            LEFT JOIN kameraden k ON m.kamerad_id = k.id
                            $where ORDER BY m.kennung ASC");
    $stmt->bind_param("sss", $suchbegriff, $suchbegriff, $suchbegriff);
} else {
    $stmt = $conn->prepare("SELECT m.*, k.vorname, k.nachname FROM melder m
                            LEFT JOIN kameraden k ON m.kamerad_id = k.id
                            ORDER BY m.kennung ASC");
}
$stmt->execute();
$melder = $stmt->get_result();

// Kameraden abrufen
$kameraden = $conn->query("SELECT id, vorname, nachname FROM kameraden ORDER BY nachname ASC");
?>

<div class="container my-5">
  <h2 class="mb-4">Meldeempfänger Verwaltung</h2>
  <?= $meldung ?>

  <div class="d-flex justify-content-between mb-4">
    <form method="get" class="d-flex">
      <input type="text" name="suche" class="form-control me-2" placeholder="Suche Seriennummer, Typ oder Kennung" value="<?= htmlspecialchars($_GET['suche'] ?? '') ?>">
      <button type="submit" class="btn btn-primary me-2">Suchen</button>
      <a href="?export=csv" class="btn btn-outline-secondary">CSV Export</a>
    </form>

    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#melderModal">Neuen Melder hinzufügen</button>
  </div>

  <div class="table-responsive">
    <table class="table table-bordered table-hover">
      <thead class="table-dark">
        <tr>
          <th>Kennung</th>
          <th>Typ</th>
          <th>Seriennummer</th>
          <th>Kamerad</th>
          <th>Ausgabe-Datum</th>
          <th>Zubehör</th>
          <th>Einheit</th>
          <th>Aktion</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($m = $melder->fetch_assoc()): ?>
          <tr>
            <td><?= htmlspecialchars($m['kennung']) ?></td>
            <td><?= htmlspecialchars($m['typ']) ?></td>
            <td><?= htmlspecialchars($m['seriennummer']) ?></td>
            <td><?= $m['vorname'] ? htmlspecialchars($m['vorname'] . ' ' . $m['nachname']) : '-' ?></td>
            <td><?= $m['ausgabe_datum'] ? date('d.m.Y', strtotime($m['ausgabe_datum'])) : '-' ?></td>
            <td>
              <?= $m['ladegeraet'] ? '🔌 Ladegerät ' : '' ?>
              <?= $m['antenne'] ? '📡 Antenne ' : '' ?>
              <?= $m['schutztasche'] ? '👜 Schutztasche' : '' ?>
            </td>
            <td><?= htmlspecialchars($m['einheit']) ?></td>
            <td>
              <a href="melder_edit.php?id=<?= $m['id'] ?>" class="btn btn-sm btn-primary">Bearbeiten</a>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="melderModal" tabindex="-1" aria-labelledby="melderModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content bg-white">
      <div class="modal-header">
        <h5 class="modal-title" id="melderModalLabel">Neuen Melder hinzufügen</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <form method="post">
        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Kennung</label>
            <input type="text" name="kennung" class="form-control" value="<?= htmlspecialchars($einheit) ?>">
          </div>
          <div class="mb-3">
            <label class="form-label">Seriennummer*</label>
            <input type="text" name="seriennummer" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Typ*</label>
            <input type="text" name="typ" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Ausgabe-Datum</label>
            <input type="date" name="ausgabe_datum" class="form-control">
          </div>
          <div class="mb-3">
            <label class="form-label">Einheit</label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($einheit) ?>" disabled>
            <input type="hidden" name="einheit" value="<?= htmlspecialchars($einheit) ?>">
          </div>
          <div class="mb-3">
            <label class="form-label">Kamerad (optional)</label>
            <select name="kamerad_id" class="form-select">
              <option value="">- Keine Auswahl -</option>
              <?php while ($k = $kameraden->fetch_assoc()): ?>
                <option value="<?= $k['id'] ?>"><?= htmlspecialchars($k['vorname'] . ' ' . $k['nachname']) ?></option>
              <?php endwhile; ?>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Zubehör</label><br>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="checkbox" name="ladegeraet" id="ladegeraet">
              <label class="form-check-label" for="ladegeraet">Ladegerät</label>
            </div>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="checkbox" name="antenne" id="antenne">
              <label class="form-check-label" for="antenne">Antenne</label>
            </div>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="checkbox" name="schutztasche" id="schutztasche">
              <label class="form-check-label" for="schutztasche">Schutztasche</label>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" name="melder_hinzufuegen" class="btn btn-primary">Speichern</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Schließen</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
