<?php
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';
session_start();
ob_start();

$lieferschein_id = (int)($_GET['id'] ?? 0);
$meldung = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kommentar = trim($_POST['rueckmeldung']);
    $stmt = $conn->prepare("UPDATE lieferscheine SET status = 'geliefert', rueckmeldung = ?, rueckmelde_datum = NOW() WHERE id = ?");
    $stmt->bind_param("si", $kommentar, $lieferschein_id);
    $stmt->execute();
    header("Location: lieferschein_liste.php");
    exit;
}
?>

<div class="container my-5">
  <h2>✅ Rückmeldung zu Lieferschein #<?= $lieferschein_id ?></h2>

  <form method="post">
    <div class="mb-3">
      <label class="form-label">Kommentar / Bestätigung</label>
      <textarea name="rueckmeldung" class="form-control" rows="4" placeholder="Optionaler Hinweis zur Lieferung..."></textarea>
    </div>
    <button class="btn btn-success">✅ Als geliefert bestätigen</button>
    <a href="lieferschein_liste.php" class="btn btn-secondary">Zurück</a>
  </form>
</div>

<?php include 'includes/footer.php'; ?>
<?php ob_end_flush(); ?>
