<?php
include 'includes/db.php';
include 'includes/header.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$lieferschein_id = (int)($_GET['id'] ?? 0);

// Lieferscheindaten
$stmt = $conn->prepare("SELECT l.*, u.vorname, u.nachname, a.bezeichnung, a.strasse, a.plz, a.ort, a.hinweis
                        FROM lieferscheine l
                        LEFT JOIN users u ON l.erstellt_von = u.id
                        LEFT JOIN adressen a ON l.adresse_id = a.id
                        WHERE l.id = ?");
$stmt->bind_param("i", $lieferschein_id);
$stmt->execute();
$lieferschein = $stmt->get_result()->fetch_assoc();

if (!$lieferschein) {
    echo "<div class='container mt-5'><div class='alert alert-danger'>Lieferschein nicht gefunden.</div></div>";
    exit;
}

// Geräte inkl. Fahrzeug laden
$geraete = $conn->query("
    SELECT
        g.bezeichnung,
        g.barcode,
        f.fahrzeugname
    FROM lieferschein_geraete lg
    JOIN ffw_geraete g ON lg.geraet_id = g.id
    LEFT JOIN ffw_fahrzeuge f ON g.fahrzeug = f.barcode_fzg
    WHERE lg.lieferschein_id = $lieferschein_id
")->fetch_all(MYSQLI_ASSOC);

// Freie Positionen
$positionen = $conn->query("
    SELECT * FROM lieferschein_positionen
    WHERE lieferschein_id = $lieferschein_id
")->fetch_all(MYSQLI_ASSOC);
?>

<style>
@media print {
  .no-print { display: none; }
  .page-break { page-break-before: always; }
}

.page {
  max-width: 800px;
  margin: auto;
  padding: 40px;
  font-family: Arial, sans-serif;
  background: white;
  border: 1px solid #ccc;
}

.logo {
  height: 80px;
}

table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 20px;
  page-break-inside: auto;
}

th, td {
  border: 1px solid #999;
  padding: 8px;
  page-break-inside: avoid;
}

th {
  background: #eee;
}
</style>


<div class="page">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <img src="../img/logo2.png" width="150px" height="150px">
    <h2>Lieferschein</h2>
  </div>

  <p><strong>Lieferscheinnummer:</strong> <?= $lieferschein['id'] ?><br>
     <strong>Einheit:</strong> <?= htmlspecialchars($lieferschein['einheit']) ?><br>
     <strong>Erstellt von:</strong> <?= htmlspecialchars($lieferschein['vorname'] . ' ' . $lieferschein['nachname']) ?><br>
     <strong>Lieferdatum:</strong> <?= date('d.m.Y', strtotime($lieferschein['lieferdatum'])) ?><br>
     <strong>Status:</strong> <?= ucfirst($lieferschein['status']) ?></p>

  <hr>

  <h5>Empfänger</h5>
  <p>
    <strong><?= htmlspecialchars($lieferschein['empfaenger']) ?></strong><br>
    <?= htmlspecialchars($lieferschein['bezeichnung']) ?><br>
    <?= htmlspecialchars($lieferschein['strasse']) ?><br>
    <?= $lieferschein['plz'] . ' ' . htmlspecialchars($lieferschein['ort']) ?><br>
    <?php if ($lieferschein['hinweis']): ?>
      <small><em><?= nl2br(htmlspecialchars($lieferschein['hinweis'])) ?></em></small>
    <?php endif; ?>
  </p>

  <h5 class="mt-4">📦 Geräte</h5>
  <table>
    <thead>
      <tr>
        <th>#</th>
        <th>Bezeichnung</th>
        <th>Barcode</th>
        <th>Fahrzeug</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($geraete as $index => $g): ?>
      <tr>
        <td><?= $index+1 ?></td>
        <td><?= htmlspecialchars($g['bezeichnung']) ?></td>
        <td><?= htmlspecialchars($g['barcode']) ?></td>
        <td><?= htmlspecialchars($g['fahrzeugname'] ?? '-') ?></td>
      </tr>
      <?php endforeach; ?>
      <?php if (empty($geraete)): ?>
        <tr><td colspan="4">Keine Geräte enthalten.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>

  <h5 class="mt-4">🧾 Freie Positionen</h5>
  <table>
    <thead><tr><th>#</th><th>Bezeichnung</th><th>Menge</th><th>Bemerkung</th></tr></thead>
    <tbody>
      <?php foreach ($positionen as $index => $p): ?>
      <tr>
        <td><?= $index+1 ?></td>
        <td><?= htmlspecialchars($p['bezeichnung']) ?></td>
        <td><?= htmlspecialchars($p['menge']) ?></td>
        <td><?= htmlspecialchars($p['bemerkung']) ?></td>
      </tr>
      <?php endforeach; ?>
      <?php if (empty($positionen)): ?>
        <tr><td colspan="4">Keine Positionen enthalten.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>

  <?php if ($lieferschein['status'] === 'geliefert'): ?>
    <h5 class="mt-4">✅ Rückmeldung</h5>
    <p><strong>Am:</strong> <?= date('d.m.Y H:i', strtotime($lieferschein['rueckmelde_datum'])) ?><br>
       <strong>Info:</strong> <?= nl2br(htmlspecialchars($lieferschein['rueckmeldung'])) ?></p>
  <?php endif; ?>

  <div class="no-print mt-4">
    <a href="javascript:window.print()" class="btn btn-primary">🖨️ Drucken</a>
    <a href="lieferschein_liste.php" class="btn btn-secondary">🔙 Zurück</a>
  </div>
</div>
