<?php
include 'includes/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$einheit = $_SESSION['einheit'];

$empfaenger = $_POST['empfaenger'] ?? '';
$lieferdatum = $_POST['lieferdatum'] ?? date('Y-m-d');
$adresse_id = (int)($_POST['adresse_id'] ?? 0);

// Lieferschein speichern
$stmt = $conn->prepare("INSERT INTO lieferscheine (einheit, erstellt_von, lieferdatum, empfaenger, adresse_id) VALUES (?, ?, ?, ?, ?)");
$stmt->bind_param("sissi", $einheit, $user_id, $lieferdatum, $empfaenger, $adresse_id);
$stmt->execute();
$lieferschein_id = $stmt->insert_id;

// Geräte speichern
if (!empty($_POST['geraete'])) {
    foreach ($_POST['geraete'] as $geraet_id) {
        $stmt = $conn->prepare("INSERT INTO lieferschein_geraete (lieferschein_id, geraet_id) VALUES (?, ?)");
        $stmt->bind_param("ii", $lieferschein_id, $geraet_id);
        $stmt->execute();
    }
}

// Freie Positionen speichern
$freie_bezeichnung = $_POST['freie_bezeichnung'] ?? [];
$freie_menge = $_POST['freie_menge'] ?? [];
$freie_bemerkung = $_POST['freie_bemerkung'] ?? [];

for ($i = 0; $i < count($freie_bezeichnung); $i++) {
    $bez = trim($freie_bezeichnung[$i]);
    $menge = trim($freie_menge[$i]);
    $bem = trim($freie_bemerkung[$i]);

    if ($bez !== '') {
        $stmt = $conn->prepare("INSERT INTO lieferschein_positionen (lieferschein_id, bezeichnung, menge, bemerkung) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("isss", $lieferschein_id, $bez, $menge, $bem);
        $stmt->execute();
    }
}

// Weiterleitung zur Druckansicht
header("Location: lieferschein_druck.php?id=$lieferschein_id");
exit;
