<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

include_once __DIR__ . '/PHPMailer/PHProcksAutoloader.php';
include_once __DIR__ . '/../includes/db.php';

session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['root'] != 1) {
    echo "Kein Zugriff.";
    exit;
}

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    echo "Ungültige ID.";
    exit;
}

// Neues Passwort erzeugen
$neues_pw = bin2hex(random_bytes(4)); // z. B. 8-stellig
$hash = password_hash($neues_pw, PASSWORD_DEFAULT);

// User-Daten holen
$result = $conn->query("SELECT * FROM users WHERE id = $id");
$user = $result->fetch_assoc();
if (!$user) {
    echo "Benutzer nicht gefunden.";
    exit;
}

// Passwort speichern
$conn->query("UPDATE users SET password = '$hash' WHERE id = $id");

// Nachricht (plain)
$nachricht = "Ein neues Passwort wurde erstellt:\n\n";
$nachricht .= sprintf("%-15s %-35s\n", "Benutzer:", $user['vorname'] . ' ' . $user['nachname']);
$nachricht .= sprintf("%-15s %-35s\n", "E-Mail:", $user['email']);
$nachricht .= sprintf("%-15s %-35s\n", "Einheit:", $user['einheit']);
$nachricht .= sprintf("%-15s %-35s\n", "Neues Passwort:", $neues_pw);

$nachricht_html = "<pre>" . htmlspecialchars($nachricht) . "</pre>";

// HTML-Mail
$html = <<<HTML
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <style>
    body { font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px; }
    .container { max-width: 900px; margin: auto; background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    .header { background: #0d6efd; color: #fff; padding: 15px; font-size: 20px; font-weight: bold; text-align: center; border-radius: 10px 10px 0 0; }
    .content { padding: 20px; font-size: 16px; color: #333; }
    pre { background: #f8f9fa; padding: 10px; border-radius: 6px; font-family: monospace; overflow-x: auto; }
    .footer { margin-top: 20px; font-size: 14px; color: #888; text-align: center; }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">🔐 Passwort zurückgesetzt</div>
    <div class="content">
      <p>Moin {$user['vorname']},</p>
      <p>dein Passwort wurde vom Administrator zurückgesetzt. Du kannst dich jetzt mit folgendem Passwort einloggen:</p>
      {$nachricht_html}
      <p>Bitte ändere das Passwort nach dem Login in deinen Einstellungen.</p>
    </div>
    <div class="footer">&copy; app.f-invent.de</div>
  </div>
</body>
</html>
HTML;

// Mail senden
$mail = new PHPMailer();
$mail->CharSet = 'UTF-8';
$mail->isSMTP();
$mail->Host = 'mail.f-invent.de';
$mail->SMTPAuth = true;
$mail->Username = 'noreply@f-invent.de';
$mail->Password = 'b*Y!@Ys.aKS^';
$mail->SMTPSecure = 'tls';
$mail->Port = 587;

$mail->setFrom('noreply@f-invent.de', 'app.F-Invent.de');
$mail->addReplyTo('support@cloud.f-invent.de');

$mail->addAddress($user['email']);
$mail->addBCC('ticketsystem@app.f-invent.de');

$mail->isHTML(true);
$mail->Subject = "🔐 Neues Passwort für dein Konto";
$mail->Body = $html;
$mail->AltBody = strip_tags($nachricht);

// Senden + Loggen
if ($mail->send()) {
    $status = 'erfolgreich';
    $fehler = null;
} else {
    $status = 'fehler';
    $fehler = $mail->ErrorInfo;
}

// Log
$stmt = $conn->prepare("INSERT INTO email_log (empfaenger, betreff, status, fehlertext) VALUES (?, ?, ?, ?)");
$stmt->bind_param("ssss", $user['email'], $mail->Subject, $status, $fehler);
$stmt->execute();

// Zurück zur Adminseite
header("Location: admin_users.php");
exit;
