<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

// Zugriffsschutz
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$pruefer_name = ($_SESSION['user_vorname'] ?? '') . ' ' . ($_SESSION['user_nachname'] ?? '');
$meldung = '';
$suchbegriff = trim($_GET['suche'] ?? '');

// Gerät als geprüft markieren
if (isset($_GET['geprueft'])) {
    $id = (int)$_GET['geprueft'];

    $conn->begin_transaction();

    try {
        // Update Gerät
        $stmt = $conn->prepare("UPDATE atemschutzgeraete
            SET letzte_pruefung = CURDATE(),
                naechste_pruefung = DATE_ADD(CURDATE(), INTERVAL 30 DAY),
                geprueft_von = ?
            WHERE id = ?");
        $stmt->bind_param("si", $pruefer_name, $id);
        $stmt->execute();

        // Insert Historie
        $stmt_hist = $conn->prepare("INSERT INTO atemschutz_pruefungen (geraet_id, geprueft_am, geprueft_von) VALUES (?, CURDATE(), ?)");
        $stmt_hist->bind_param("is", $id, $pruefer_name);
        $stmt_hist->execute();

        $conn->commit();
        $meldung = "<div class='alert alert-success'>Gerät geprüft durch <strong>$pruefer_name</strong> und Historie gespeichert.</div>";
    } catch (Exception $e) {
        $conn->rollback();
        $meldung = "<div class='alert alert-danger'>Fehler bei der Prüfung: " . $e->getMessage() . "</div>";
    }
}

// Neues Gerät speichern
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['geraet_hinzufuegen'])) {
    $geraetename = trim($_POST['geraetename']);
    $seriennummer = trim($_POST['seriennummer']);

    if ($geraetename !== '' && $seriennummer !== '') {
        $stmt = $conn->prepare("INSERT INTO atemschutzgeraete (geraetename, seriennummer, letzte_pruefung, naechste_pruefung) VALUES (?, ?, CURDATE(), DATE_ADD(CURDATE(), INTERVAL 30 DAY))");
        $stmt->bind_param("ss", $geraetename, $seriennummer);
        $stmt->execute();

        $meldung = "<div class='alert alert-success'>Neues Gerät hinzugefügt.</div>";
    } else {
        $meldung = "<div class='alert alert-danger'>Bitte alle Felder ausfüllen.</div>";
    }
}

// Geräte abrufen (mit oder ohne Suche)
if ($suchbegriff !== '') {
    $like = '%' . $suchbegriff . '%';
    $stmt = $conn->prepare("SELECT * FROM atemschutzgeraete WHERE geraetename LIKE ? OR seriennummer LIKE ? ORDER BY naechste_pruefung ASC");
    $stmt->bind_param("ss", $like, $like);
    $stmt->execute();
    $geraete = $stmt->get_result();
} else {
    $geraete = $conn->query("SELECT * FROM atemschutzgeraete ORDER BY naechste_pruefung ASC");
}
?>

<div class="container my-5">
  <h2 class="mb-4">Atemschutzgeräte Verwaltung</h2>

  <?= $meldung ?>

  <div class="card p-4 mb-5 bg-white shadow-sm">
    <h5>Neues Atemschutzgerät hinzufügen</h5>
    <form method="post" class="row g-3">
      <div class="col-md-5">
        <input type="text" name="geraetename" class="form-control" placeholder="Gerätename" required>
      </div>
      <div class="col-md-5">
        <input type="text" name="seriennummer" class="form-control" placeholder="Seriennummer" required>
      </div>
      <div class="col-md-2 d-grid">
        <button type="submit" name="geraet_hinzufuegen" class="btn btn-primary">Hinzufügen</button>
      </div>
    </form>
  </div>

  <div class="card p-4 mb-4 bg-white shadow-sm">
    <h5 class="mb-3">Atemschutzgerät suchen</h5>
    <form method="get" class="row g-3">
      <div class="col-md-10">
        <input type="text" name="suche" class="form-control" placeholder="Gerätename oder Seriennummer eingeben..." value="<?= htmlspecialchars($suchbegriff) ?>">
      </div>
      <div class="col-md-2 d-grid">
        <button type="submit" class="btn btn-secondary">Suchen</button>
      </div>
    </form>
  </div>

  <div class="table-responsive">
    <table class="table table-bordered table-hover bg-white">
      <thead class="table-dark">
        <tr>
          <th>Gerätename</th>
          <th>Seriennummer</th>
          <th>Letzte Prüfung</th>
          <th>Nächste Prüfung</th>
          <th>Geprüft von</th>
          <th>Aktion</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($geraete->num_rows > 0): ?>
          <?php while ($g = $geraete->fetch_assoc()): ?>
            <?php
              $heute = strtotime(date('Y-m-d'));
              $naechste = strtotime($g['naechste_pruefung']);
              $tage_diff = floor(($naechste - $heute) / (60 * 60 * 24));

              if ($tage_diff <= 3) {
                  $farbe = 'table-danger'; // Rot
              } elseif ($tage_diff <= 7) {
                  $farbe = 'table-warning'; // Gelb
              } else {
                  $farbe = 'table-success'; // Grün
              }
            ?>
            <tr class="<?= $farbe ?>">
              <td><?= htmlspecialchars($g['geraetename']) ?></td>
              <td><?= htmlspecialchars($g['seriennummer']) ?></td>
              <td><?= date('d.m.Y', strtotime($g['letzte_pruefung'])) ?></td>
              <td><?= date('d.m.Y', strtotime($g['naechste_pruefung'])) ?></td>
              <td><?= htmlspecialchars($g['geprueft_von'] ?? '-') ?></td>
              <td>
                <a href="?geprueft=<?= $g['id'] ?>" class="btn btn-sm btn-success" onclick="return confirm('Gerät wirklich als geprüft markieren?')">Geprüft</a>
                <a href="atemschutz_historie.php?id=<?= $g['id'] ?>" class="btn btn-sm btn-info">Historie</a>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr>
            <td colspan="6" class="text-center text-muted">Keine Geräte gefunden.</td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

</div>

<?php include 'includes/footer.php'; ?>
