<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

$id = (int)($_GET['id'] ?? 0);

if (!$id) {
    header('Location: atemschutz.php');
    exit;
}

// Gerät holen
$stmt = $conn->prepare("SELECT geraetename FROM atemschutzgeraete WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$geraet = $stmt->get_result()->fetch_assoc();

// Historie holen
$stmt = $conn->prepare("SELECT * FROM atemschutz_pruefungen WHERE geraet_id = ? ORDER BY geprueft_am DESC");
$stmt->bind_param("i", $id);
$stmt->execute();
$historie = $stmt->get_result();
?>

<div class="container my-5">
  <a href="atemschutz.php" class="btn btn-secondary mb-3">&laquo; Zurück</a>
  <h2>Prüf-Historie: <?= htmlspecialchars($geraet['geraetename']) ?></h2>

  <div class="table-responsive mt-4">
    <table class="table table-bordered">
      <thead class="table-dark">
        <tr>
          <th>Geprüft am</th>
          <th>Geprüft von</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($h = $historie->fetch_assoc()): ?>
          <tr>
            <td><?= date('d.m.Y', strtotime($h['geprueft_am'])) ?></td>
            <td><?= htmlspecialchars($h['geprueft_von']) ?></td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
