<?php
session_start();
include 'includes/db.php';

$lager_id = $_GET['id'] ?? null;
$meldung = '';
$artikel = null;

// Artikel anzeigen
if ($lager_id) {
    $stmt = $conn->prepare("SELECT * FROM lager_bestand WHERE id = ?");
    $stmt->bind_param("i", $lager_id);
    $stmt->execute();
    $artikel = $stmt->get_result()->fetch_assoc();
}

// Buchung verarbeiten
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $artikel) {
    $buchungstyp = $_POST['buchungstyp'] === 'Abgang' ? 'Abgang' : 'Zugang';
    $anzahl = max(1, (int)$_POST['anzahl']);
    $bemerkung = trim($_POST['bemerkung']);
    $kamerad_id = $_SESSION['user_id'] ?? null;

    $neuerBestand = $artikel['bestand'] + ($buchungstyp === 'Zugang' ? $anzahl : -$anzahl);

    if ($neuerBestand < 0) {
        $meldung = "<div class='alert alert-danger text-center'>❌ Nicht genügend Bestand vorhanden!</div>";
    } else {
        $stmt = $conn->prepare("UPDATE lager_bestand SET bestand = ? WHERE id = ?");
        $stmt->bind_param("ii", $neuerBestand, $lager_id);
        $stmt->execute();

        $stmt = $conn->prepare("INSERT INTO lager_historie (lager_id, buchungstyp, anzahl, kamerad_id, bemerkung) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("issis", $lager_id, $buchungstyp, $anzahl, $kamerad_id, $bemerkung);
        $stmt->execute();

        $meldung = "<div class='alert alert-success text-center'>✅ {$buchungstyp} von {$anzahl} Stück erfolgreich verbucht.</div>";

        $stmt = $conn->prepare("SELECT * FROM lager_bestand WHERE id = ?");
        $stmt->bind_param("i", $lager_id);
        $stmt->execute();
        $artikel = $stmt->get_result()->fetch_assoc();
    }
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <title>Lager QR-Zugang</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #f9f9f9;
    }
    .card h4 {
      font-size: 1.5rem;
    }
    .btn {
      font-size: 1.2rem;
      padding: 0.75rem;
    }
    input, select, textarea {
      font-size: 1.2rem;
    }
    .container {
      max-width: 500px;
    }
  </style>
</head>
<body>
<div class="container py-4">
  <h2 class="mb-4 text-center">📦 Lagerbuchung</h2>

  <?php if (!$artikel): ?>
    <div class="alert alert-danger text-center">Artikel nicht gefunden oder ID fehlt.</div>
  <?php else: ?>
    <?= $meldung ?>
    <div class="card shadow-sm mb-4">
      <div class="card-body">
        <h4 class="card-title"><?= htmlspecialchars($artikel['artikelname']) ?></h4>
        <p class="mb-1"><strong>Artikelnummer:</strong> <?= htmlspecialchars($artikel['artikelnummer']) ?></p>
        <p class="mb-1"><strong>Kategorie:</strong> <?= htmlspecialchars($artikel['kategorie']) ?></p>
        <p class="mb-1"><strong>Größe:</strong> <?= htmlspecialchars($artikel['groesse']) ?></p>
        <p class="fw-bold"><strong>Bestand:</strong> <?= (int)$artikel['bestand'] ?> Stück</p>
      </div>
    </div>

    <form method="post" class="card shadow-sm p-4">
      <div class="mb-3">
        <label class="form-label">Buchungstyp</label>
        <select name="buchungstyp" class="form-select" required>
          <option value="Zugang">➕ Zugang</option>
          <option value="Abgang">➖ Abgang</option>
        </select>
      </div>

      <div class="mb-3">
        <label class="form-label">Anzahl</label>
        <input type="number" name="anzahl" class="form-control" value="1" min="1" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Bemerkung</label>
        <input type="text" name="bemerkung" class="form-control" placeholder="z. B. Spind 5, Defekt, Rückgabe">
      </div>

      <button type="submit" class="btn btn-primary w-100">📥 Buchung durchführen</button>
    </form>
  <?php endif; ?>
</div>
</body>
</html>
