<?php
// 🗂️ Absoluter Pfad zum Quellordner, der gesichert werden soll
$sourceFolder = '/home2/kd54698/app.f-invent.de';

// 📁 Absoluter Pfad zum Zielordner für das Backup
$backupFolder = '/home2/kd54698/io.f-invent.de/backup';

// 📦 Backup-Dateiname mit Zeitstempel
$date = date('Y-m-d_H-i-s');
$zipFile = $backupFolder . '/backup_' . $date . '.zip';

// 📁 Backup-Ordner erstellen, falls nicht vorhanden
if (!file_exists($backupFolder)) {
    mkdir($backupFolder, 0775, true);
}

// 📦 ZIP-Datei erzeugen
$zip = new ZipArchive();
if ($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($sourceFolder, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::LEAVES_ONLY
    );

    foreach ($files as $file) {
        if (!$file->isDir()) {
            $filePath = $file->getRealPath();
            $relativePath = substr($filePath, strlen($sourceFolder) + 1);
            $zip->addFile($filePath, $relativePath);
        }
    }

    $zip->close();
    echo "✅ Backup erfolgreich erstellt: " . basename($zipFile);
} else {
    echo "❌ Fehler beim Erstellen der ZIP-Datei.";
}
?>
