<?php
include "includes/db.php";
ob_start(); session_start();

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit();
}

include "includes/header.php";
include "includes/nav.php";
?>

<div class="container mt-5">
    <h2>Moin <? echo $vorname; ?></h2>
</div>
<div class="container my-5">
  <form method="post" action="geraet_edit.php" class="mt-4">
    <div class="input-group">
      <input type="text" name="barcode" class="form-control" placeholder="Geräte-Barcode eingeben..." required>
      <button type="submit" class="btn btn-primary">Bearbeiten</button>
    </div>
  </form>
</div>

<?php
// News abrufen, "Info"-Kategorie bevorzugt sortieren
$sql = "SELECT * FROM news ORDER BY (kategorie = 'Info') DESC, highlight DESC, erstellt_am DESC";
$result = $conn->query($sql);

$user_id = $_SESSION['user_id'] ?? 0;
$aufgaben_anzahl = 0;

if ($user_id) {
    $stmt_aufgaben = $conn->prepare("SELECT COUNT(*) AS offen FROM aufgaben WHERE empfaenger_id = ? AND status != 'erledigt'");
    $stmt_aufgaben->bind_param("i", $user_id);
    $stmt_aufgaben->execute();
    $res = $stmt_aufgaben->get_result()->fetch_assoc();
    $aufgaben_anzahl = $res['offen'] ?? 0;
}



?>

<style>
.card-img-top {
  max-height: 180px;
  object-fit: cover;
  width: 100%;
}
.card:hover {
  transform: translateY(-2px);
  box-shadow: 0 6px 20px rgba(0,0,0,0.1);
  transition: all 0.2s ease-in-out;
}
.card-info {
  background-color: #fff0f0;
  border-left: 4px solid #dc3545;
}
</style>

<div class="container my-5">
  <h2 class="mb-4 text-primary">📢 Aktuelle News & Infos</h2>
  <?php if ($aufgaben_anzahl > 0): ?>
    <div class="alert alert-info mt-4">
      📌 Du hast noch <strong><?= $aufgaben_anzahl ?></strong> offene Aufgabe<?= $aufgaben_anzahl == 1 ? '' : 'n' ?>!
      <a href="aufgaben.php" class="btn btn-sm btn-outline-primary ms-3">Jetzt ansehen</a>
    </div>
  <?php endif; ?>

  <!-- Bootstrap 5 Beispiel -->
<div class="alert alert-primary d-flex justify-content-between align-items-center rounded-3 shadow-sm p-3 mb-4" role="alert">
  <div>
    <h5 class="mb-1">🆕 Neues Modul: Bestellwesen *BETA*</h5>
    <p class="mb-0 small">Stelle ab sofort Artikel zusammen, sende Bestellungen verbindlich ab und behalte alles im Blick – direkt im neuen Bestellwesen-Modul.</p>
  </div>
  <a href="cart.php" class="btn btn-sm btn-outline-primary position-relative">
    Modul öffnen
    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
      NEU
      <span class="visually-hidden">Neues Modul</span>
    </span>
  </a>
</div>


  <div class="row g-4">
    <?php while ($n = $result->fetch_assoc()): ?>
      <div class="col-md-6">
        <div class="card shadow-sm h-100 border-0
          <?= $n['kategorie'] === 'Info'
              ? 'card-info'
              : ($n['highlight'] ? 'bg-warning-subtle border-warning' : 'bg-light') ?>">

          <?php if ($n['bild']): ?>
            <img src="uploads/news_bilder/<?= htmlspecialchars($n['bild']) ?>" class="card-img-top rounded-top" alt="News-Bild">
          <?php endif; ?>

          <div class="card-body">
            <h5 class="card-title mb-2 fw-bold text-dark"><?= htmlspecialchars($n['titel']) ?></h5>
            <p class="card-text small text-muted"><?= nl2br(htmlspecialchars($n['inhalt'])) ?></p>

            <?php if ($n['dokument']): ?>
              <a href="uploads/news_dokumente/<?= htmlspecialchars($n['dokument']) ?>" target="_blank" class="btn btn-outline-primary btn-sm mt-2">📄 PDF anzeigen</a>
            <?php endif; ?>
          </div>
          <div class="card-footer bg-transparent text-end small text-muted">
            <?= date("d.m.Y H:i", strtotime($n['erstellt_am'])) ?> – <?= htmlspecialchars($n['verfasser']) ?>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
</div>

<?php include "includes/footer.php"; ?>
