<?php
session_start();
include '../includes/db.php';
include '../includes/header.php';
include '../includes/nav.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Benutzerinfos laden
$stmt = $conn->prepare("SELECT username, vorname, nachname, root FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['root'] != 1) {
    echo '<div class="container mt-5 alert alert-danger">❌ Zugriff verweigert. Du hast keine Administratorrechte.</div>';
    include 'includes/footer.php';
    exit;
}
?>

<div class="container mt-5">
    <h1 class="mb-4">⚙️ Adminbereich</h1>

    <div class="alert alert-success">
        Willkommen, <strong><?= htmlspecialchars($user['vorname'] . ' ' . $user['nachname']) ?></strong>! Du hast Root-Zugriff.
    </div>

    <ul class="list-group mt-4">
        <li class="list-group-item"><a href="../includes/backups/backup_uebersicht.php">📦 Datenbank-Backups verwalten</a></li>
        <li class="list-group-item"><a href="admin_users2.php">👥 Benutzerverwaltung</a></li>
        <li class="list-group-item"><a href="logs.php">📑 System-Logs</a></li>
        <!-- Weitere Admin-Funktionen hier -->
    </ul>
</div>

<?php include '../includes/footer.php'; ?>
