<?php
session_start();
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$einheit = $_SESSION['einheit'] ?? '';

$sql = "
SELECT g.*
FROM ffw_geraete g
JOIN ffw_favoriten f ON g.id = f.geraet_id
WHERE f.user_id = ? AND g.einheit = ?
ORDER BY g.bezeichnung ASC
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("is", $user_id, $einheit);
$stmt->execute();
$result = $stmt->get_result();
?>

<div class="container mt-5">
    <h1 class="mb-4">📌 Meine Favoriten</h1>

    <?php if ($result->num_rows > 0): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle text-center">
                <thead class="table-light">
                    <tr>
                        <th>Bezeichnung</th>
                        <th>Barcode</th>
                        <th>Kategorie</th>
                        <th>Geräteraum</th>
                        <th>Status</th>
                        <th>Letzte Prüfung</th>
                        <th>Nächste Prüfung</th>
                        <th>Aktion</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <?php
                            $nächste = strtotime('+1 year', $row['lpruefung']);
                            $tage_diff = floor(($nächste - time()) / (60 * 60 * 24));
                            $bg = 'table-success';
                            if ($tage_diff < 7) $bg = 'table-danger';
                            elseif ($tage_diff < 30) $bg = 'table-warning';
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($row['bezeichnung']) ?></td>
                            <td><?= htmlspecialchars($row['barcode']) ?></td>
                            <td><?= htmlspecialchars($row['kat']) ?></td>
                            <td><?= htmlspecialchars($row['gr']) ?></td>
                            <td><?= htmlspecialchars($row['status']) ?></td>
                            <td><?= date("d.m.Y", $row['lpruefung']) ?></td>
                            <td class="<?= $bg ?>"><?= date("d.m.Y", $nächste) ?></td>
                            <td>
                                <form method="post" action="geraet_edit.php" class="m-0">
                                    <input type="hidden" name="barcode" value="<?= htmlspecialchars($row['barcode']) ?>">
                                    <button type="submit" class="btn btn-sm btn-outline-primary">Bearbeiten</button>
                                </form>
                                <form method="post" action="favorit_toggle.php" class="d-inline">
                                    <input type="hidden" name="geraet_id" value="<?= $row['id'] ?>">
                                    <button class="btn btn-sm btn-warning" name="toggle_fav">★ Entfernen</button>
                                </form>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info">Keine Favoriten gefunden.</div>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
