<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

$meldung = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vorname = trim($_POST['vorname']);
    $nachname = trim($_POST['nachname']);
    $email = trim($_POST['email']);
    $spindnr = trim($_POST['spindnr']);

    if ($vorname && $nachname && $spindnr) {
        $stmt = $conn->prepare("INSERT INTO kameraden (vorname, nachname, email, spindnr) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $vorname, $nachname, $email, $spindnr);
        if ($stmt->execute()) {
            $meldung = "<div class='alert alert-success'>Kamerad erfolgreich hinzugefügt.</div>";
        } else {
            $meldung = "<div class='alert alert-danger'>Fehler beim Speichern.</div>";
        }
    } else {
        $meldung = "<div class='alert alert-warning'>Bitte Vorname, Nachname und Spindnummer ausfüllen.</div>";
    }
}
?>

<div class="container my-5">
  <h2 class="mb-4">Neuen Kameraden hinzufügen</h2>

  <?= $meldung ?>

  <form method="post">
    <div class="mb-3">
      <label class="form-label">Vorname</label>
      <input type="text" name="vorname" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Nachname</label>
      <input type="text" name="nachname" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">E-Mail (optional)</label>
      <input type="email" name="email" class="form-control">
    </div>
    <div class="mb-3">
      <label class="form-label">Spindnummer</label>
      <input type="text" name="spindnr" class="form-control" required>
    </div>

    <button type="submit" class="btn btn-primary">Speichern</button>
  </form>
</div>

<?php include 'includes/footer.php'; ?>
