<?php
session_start();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/PHPMailer/PHProcksAutoloader.php';
require_once __DIR__ . '/../includes/db.php';

// Session-Benutzername für Signatur (Fallback falls nicht vorhanden)
$benutzer = ($_SESSION['user_vorname'] ?? '') . ' ' . ($_SESSION['user_nachname'] ?? 'System');

$subject = "📢 Neue News auf cloud.F-Invent";

$oMailer = new PHPMailer();
$oMailer->CharSet = 'UTF-8';
$oMailer->isSMTP();
$oMailer->Host = 'mail.f-invent.de';
$oMailer->SMTPAuth = true;
$oMailer->Username = 'noreply@f-invent.de';
$oMailer->Password = 'b*Y!@Ys.aKS^';
$oMailer->SMTPSecure = 'tls';
$oMailer->Port = 587;

$oMailer->setFrom('noreply@f-invent.de', 'cloud.F-Invent');
$oMailer->addReplyTo('support@cloud.f-invent.de');
$oMailer->addAddress('noreply@f-invent.de'); // Sichtbarer Empfänger (z. B. noreply)
$oMailer->addBCC('system@cloud.f-invent.de'); // Optional feste BCC-Adresse

// E-Mail-Inhalt
$text1 = <<<HTML
<!DOCTYPE html>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <title>Neue News auf cloud.F-Invent</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Arial, sans-serif;
      background-color: #f6f6f6;
      padding: 40px 20px;
      margin: 0;
    }

    .email-container {
      background-color: #ffffff;
      border-radius: 12px;
      max-width: 600px;
      margin: auto;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
      overflow: hidden;
    }

    .header {
      background-color: #0061bd;
      color: #ffffff;
      padding: 20px 30px;
      font-size: 22px;
      font-weight: bold;
      letter-spacing: 0.5px;
    }

    .content {
      padding: 30px;
      font-size: 16px;
      color: #444444;
      line-height: 1.6;
    }

    .highlight {
      background-color: #eaf4ff;
      padding: 16px 20px;
      border-radius: 8px;
      margin: 20px 0;
    }

    a.button {
      display: inline-block;
      background-color: #0061bd;
      color: #ffffff;
      padding: 12px 24px;
      font-size: 15px;
      text-decoration: none;
      border-radius: 6px;
      margin-top: 10px;
    }

    .footer {
      font-size: 13px;
      color: #888888;
      text-align: center;
      padding: 20px;
      background-color: #f1f1f1;
    }
  </style>
</head>
<body>
  <div class="email-container">
    <div class="header">📢 Neue News auf cloud.F-Invent</div>
    <div class="content">
      Hallo,<br><br>

      auf der Plattform <strong>cloud.F-Invent</strong> wurden neue Informationen oder News veröffentlicht.

      <div class="highlight">
        <center>👉 Schau doch mal rein und bleibe auf dem neuesten Stand.<br><br>
        <a href="https://app.f-invent.de" target="_blank" class="button">Jetzt ansehen</a></center>
      </div>

      Die News können wichtige Hinweise, organisatorische Mitteilungen oder technische Neuerungen enthalten.<br><br>

      Viele Grüße<br>
      <strong>$benutzer</strong> über cloud.F-Invent
    </div>
    <div class="footer">
      Dies ist eine automatisch generierte E-Mail. Bitte nicht direkt antworten.
    </div>
  </div>
</body>
</html>

HTML;

// Inhalt setzen
$oMailer->isHTML(true);
$oMailer->Subject = $subject;
$oMailer->Body = $text1;
$oMailer->AltBody = strip_tags($text1);

// Benutzer aus der DB laden und als BCC hinzufügen
$sql = "SELECT email FROM users WHERE email != ''";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $oMailer->addBCC($row['email']);
    }
} else {
    echo "⚠️ Keine gültigen Empfänger gefunden.";
    exit;
}

// Mail senden
if (!$oMailer->send()) {
    echo "❌ Fehler beim Senden der E-Mail: " . $oMailer->ErrorInfo;
    exit;
}

echo "✅ E-Mail wurde erfolgreich an alle versendet.";
?>
