<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
require_once __DIR__ . '/includes/db.php';

function db(){
  static $m=null;
  if($m instanceof mysqli) return $m;
  $m=new mysqli('localhost','DB_USER','DB_PASS','kd54698_cloud');
  if($m->connect_errno) die($m->connect_error);
  $m->set_charset('utf8mb4'); return $m;
}
function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); }
function toInt($v){ return (int)preg_replace('/\D/','',(string)($v??0)); }

if(session_status()===PHP_SESSION_NONE) session_start();
$einheit=$_SESSION['einheit']??null;
$mysqli=db();

// --- Geräte mit Join zu Fahrzeugnamen laden ---
$params=[]; $types='';
$sql="SELECT g.id,g.barcode,g.bezeichnung,g.kat,
             g.fahrzeug,g.standort,
             COALESCE(g.anzahl,'0') AS anzahl,
             COALESCE(g.anzahlist,'0') AS anzahlist,
             COALESCE(g.status,'') AS status,
             g.einheit,
             f.fahrzeugbezeichnung, f.fahrzeugname, f.fahrzeugkurz, f.funkrufname
      FROM ffw_geraete g
      LEFT JOIN ffw_fahrzeuge f
        ON g.fahrzeug = f.funkrufname
           OR g.fahrzeug = f.fahrzeugkurz
           OR g.fahrzeug = f.fahrzeugbezeichnung
      WHERE LOWER(COALESCE(g.status,'')) <> 'ausgesondert'";
if($einheit){ $sql.=" AND g.einheit=?"; $params[]=$einheit; $types.='s'; }
$sql.=" ORDER BY g.bezeichnung ASC,g.kat ASC,g.id ASC";
$stmt=$mysqli->prepare($sql);
if($params) $stmt->bind_param($types,...$params);
$stmt->execute(); $res=$stmt->get_result();
$rows=$res->fetch_all(MYSQLI_ASSOC); $stmt->close();

// Gruppieren nach Bezeichnung+Kat
$groups=[]; $cats=[];
foreach($rows as $r){
  $bez=trim($r['bezeichnung']?:'—');
  $kat=trim($r['kat']?:'—');
  $key=$bez.'|'.$kat;
  $sol=toInt($r['anzahl']); $ist=toInt($r['anzahlist']);
  if(!isset($groups[$key])){
    $groups[$key]=['bezeichnung'=>$bez,'kat'=>$kat,'sol'=>0,'ist'=>0,'items'=>[]];
    $cats[$kat]=true;
  }
  $groups[$key]['sol']+=$sol;
  $groups[$key]['ist']+=$ist;
  $groups[$key]['items'][]=[
    'id'=>(int)$r['id'],
    'barcode'=>$r['barcode'],
    'fahrzeug'=> $r['fahrzeugbezeichnung'] ?: ($r['fahrzeugname'] ?: $r['fahrzeug']),
    'frn'=>$r['funkrufname'],
    'standort'=>$r['standort'],
    'sol'=>$sol,
    'ist'=>$ist
  ];
}
?>
<div class="container my-4">
  <h1 class="h4 mb-3">Bestand gesamt</h1>
  <div class="table-responsive">
    <table class="table align-middle">
      <thead class="table-light">
        <tr>
          <th>Bezeichnung</th>
          <th>Kategorie</th>
          <th class="text-end">SOLL</th>
          <th class="text-end">IST</th>
          <th class="text-end">Δ</th>
          <th class="text-end">Details</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($groups as $g):
        $delta=$g['ist']-$g['sol'];
        $cls=$delta===0?'text-muted':($delta>0?'text-success':'text-danger');
      ?>
        <tr>
          <td><strong><?=h($g['bezeichnung'])?></strong></td>
          <td><?=h($g['kat'])?></td>
          <td class="text-end"><?= (int)$g['sol']?></td>
          <td class="text-end"><?= (int)$g['ist']?></td>
          <td class="text-end <?=$cls?>"><?=($delta>=0?'+':'').$delta?></td>
          <td class="text-end">
            <details>
              <summary class="btn btn-sm btn-outline-secondary">anzeigen</summary>
              <div class="mt-2">
                <table class="table table-sm">
                  <thead><tr><th>Fahrzeug</th><th>Funkruf</th><th>Standort</th><th>Barcode</th><th class="text-end">SOLL</th><th class="text-end">IST</th></tr></thead>
                  <tbody>
                    <?php foreach($g['items'] as $it): ?>
                    <tr>
                      <td><?=h($it['fahrzeug'])?></td>
                      <td><?=h($it['frn'])?></td>
                      <td><?=h($it['standort'])?></td>
                      <td><?=h($it['barcode'])?></td>
                      <td class="text-end"><?=$it['sol']?></td>
                      <td class="text-end"><?=$it['ist']?></td>
                    </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            </details>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
