<?php
// add_ticket.php – Neues Ticket erstellen (clean UI + Einheitsauswahl + Datei-Upload)
session_start();
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';

$meldung = '';

// Vorausgefüllte Daten (Falls es beim POST Fehler gab)
$name            = $_POST['name']     ?? '';
$email           = $_POST['email']    ?? '';
$spindnr         = $_POST['spindnr']  ?? '';
$einheit_auswahl = $_POST['einheit']  ?? '';
$fachbereich     = $_POST['fachbereich'] ?? '';
$beschreibung    = $_POST['beschreibung'] ?? '';

// Einheiten laden
$einheiten = [];
$res = $conn->query("SELECT id, name, name2 FROM feuerwehren ORDER BY name ASC");
while ($row = $res->fetch_assoc()) { $einheiten[] = $row; }

// Upload-Helper
function safe_filename(string $name): string {
  $name = preg_replace('/[^A-Za-z0-9._-]/', '_', $name);
  return substr($name, -180); // Dateiname begrenzen
}

function is_allowed_upload(array $file): bool {
  $okExt = ['jpg','jpeg','png','pdf'];
  $ext   = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
  if (!in_array($ext, $okExt, true)) return false;

  // Grob MIME prüfen (finfo wäre besser, reicht meist so)
  $okMime = ['image/jpeg','image/png','application/pdf'];
  $mime   = mime_content_type($file['tmp_name']);
  if ($mime === false) return false;
  if (!in_array($mime, $okMime, true)) return false;

  // 20 MB Limit
  if (($file['size'] ?? 0) > 20 * 1024 * 1024) return false;

  return true;
}

// Ticket absenden
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ticket_absenden'])) {
  $name         = trim($_POST['name'] ?? '');
  $email        = trim($_POST['email'] ?? '');
  $spindnr      = trim($_POST['spindnr'] ?? '');
  $fachbereich  = trim($_POST['fachbereich'] ?? '');
  $beschreibung = trim($_POST['beschreibung'] ?? '');
  $einheit      = trim($_POST['einheit'] ?? '');

  if ($email === '') $email = '-';

  if ($name !== '' && $fachbereich !== '' && $beschreibung !== '' && $einheit !== '') {
    $ticketnummer = 'T-' . date('Ymd') . '-' . random_int(1000, 9999);
    $bild = null;

    // Datei hochladen (optional)
    if (!empty($_FILES['anhang']['name'])) {
      if (is_uploaded_file($_FILES['anhang']['tmp_name']) && is_allowed_upload($_FILES['anhang'])) {
        $uploadDir = __DIR__ . '/uploads/tickets/';
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        $ext      = strtolower(pathinfo($_FILES['anhang']['name'], PATHINFO_EXTENSION));
        $basename = safe_filename(basename($_FILES['anhang']['name']));
        $fileName = $ticketnummer . '_' . uniqid() . '_' . $basename;
        $fullPath = $uploadDir . $fileName;

        if (move_uploaded_file($_FILES['anhang']['tmp_name'], $fullPath)) {
          // Pfad relativ für Link
          $bild = 'uploads/tickets/' . $fileName;
        } else {
          $meldung = '<div class="alert alert-danger mt-3">❌ Datei-Upload fehlgeschlagen.</div>';
        }
      } else {
        $meldung = '<div class="alert alert-danger mt-3">❌ Unzulässiger Anhang (erlaubt: JPG, PNG, PDF bis 20 MB).</div>';
      }
    }

    // Nur speichern, wenn kein Upload-Fehler vorliegt
    if ($meldung === '') {
      $stmt = $conn->prepare("
        INSERT INTO neue_tickets
          (ticketnummer, fachbereich, name, spindnr, beschreibung, status, erstellt_am, einheit, datei, email)
        VALUES
          (?,            ?,          ?,    ?,       ?,           'offen', NOW(),     ?,       ?,     ?)
      ");
      // Hinweis: Spalte `email` ist optional – falls du sie nicht hast, entferne sie aus Statement & bind_param.
      $stmt->bind_param("ssssssss", $ticketnummer, $fachbereich, $name, $spindnr, $beschreibung, $einheit, $bild, $email);
      $ok = $stmt->execute();
      $stmt->close();

      if ($ok) {
        // Mailversand (falls vorhanden)
        @include 'mail/ticket_mail_senden.php';
        $meldung = '<div class="alert alert-success mt-3">✅ Ticket <strong>' . htmlspecialchars($ticketnummer) . '</strong> wurde erstellt und an die Einheit <strong>' . htmlspecialchars($einheit) . '</strong> gesendet.</div>';

        // Formular leeren
        $name = $email = $spindnr = $beschreibung = '';
        $einheit_auswahl = $fachbereich = '';
      } else {
        $meldung = '<div class="alert alert-danger mt-3">❌ Speichern fehlgeschlagen.</div>';
      }
    }
  } else {
    $meldung = '<div class="alert alert-danger mt-3">❌ Bitte alle Pflichtfelder ausfüllen und Einheit auswählen!</div>';
  }
}
?>
<style>
  .kpi-card{border:1px solid #eee;border-radius:14px;padding:16px;background:#fff}
  .kpi-sub{font-size:.9rem;color:#6c757d}
  .kpi-val{font-size:1.2rem;font-weight:700}
  .form-card{border:1px solid #eee;border-radius:12px}
</style>

<div class="container my-5">
  <div class="d-flex justify-content-between align-items-end flex-wrap gap-2 mb-3">
    <div>
      <h2 class="mb-1">🛠️ Neues Ticket erstellen</h2>
      <div class="text-muted small">Wähle zuerst die Ziel-Einheit. Danach gibst du die Details ein.</div>
    </div>
  </div>

  <div class="alert alert-info">
    <strong>Wofür ist dieses Ticketsystem?</strong><br>
    Es entlastet die Fachwarte und sorgt für eine strukturierte Aufgabenverteilung. Bitte formuliere dein Anliegen vollständig und wähle die richtige Einheit aus.
  </div>

  <?= $meldung ?>

  <form method="post" enctype="multipart/form-data" class="card p-4 bg-white shadow-sm form-card">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Einheit *</label>
        <select name="einheit" class="form-select" required>
          <option value="">-- Einheit auswählen --</option>
          <?php foreach ($einheiten as $e): ?>
            <option value="<?= htmlspecialchars($e['name']) ?>" <?= $einheit_auswahl == $e['name'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($e['name2'] ?: $e['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
        <div class="form-text">Die gewählte Einheit sieht und bearbeitet dein Ticket.</div>
      </div>

      <div class="col-md-6">
        <label class="form-label">Fachbereich *</label>
        <select name="fachbereich" class="form-select" required>
          <option value="">-- Bitte auswählen --</option>
          <option value="Ortsbrandmeister" <?= $fachbereich==='Ortsbrandmeister'?'selected':'' ?>>Ortsbrandmeister</option>
          <option value="PSA" <?= $fachbereich==='PSA'?'selected':'' ?>>PSA</option>
          <option value="Dienstbekleidung" <?= $fachbereich==='Dienstbekleidung'?'selected':'' ?>>Dienstbekleidung</option>
          <option value="Uniform" <?= $fachbereich==='Uniform'?'selected':'' ?>>Uniform</option>
          <option value="Melder" <?= $fachbereich==='Melder'?'selected':'' ?>>Melder / Schlüssel / Transponder</option>
          <option value="Gerät" <?= $fachbereich==='Gerät'?'selected':'' ?>>Geräte</option>
        </select>
      </div>

      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
      </div>

      <div class="col-md-6">
        <label class="form-label">E-Mail</label>
        <input type="email" name="email" class="form-control" placeholder="optional" value="<?= htmlspecialchars($email) ?>">
      </div>

      <div class="col-md-6">
        <label class="form-label">Spindnummer</label>
        <input type="text" name="spindnr" class="form-control" placeholder="optional" value="<?= htmlspecialchars($spindnr) ?>">
      </div>

      <div class="col-12">
        <label class="form-label">Beschreibung *</label>
        <textarea name="beschreibung" class="form-control" rows="4" required><?= htmlspecialchars($beschreibung) ?></textarea>
      </div>

      <div class="col-md-6">
        <label class="form-label">Anhang (Bild oder PDF)</label>
        <input type="file" name="anhang" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
        <div class="form-text">Erlaubt: JPG/PNG/PDF, max. 20 MB.</div>
      </div>
    </div>

    <div class="mt-4 d-flex justify-content-end">
      <button type="submit" name="ticket_absenden" class="btn btn-primary">✅ Ticket absenden</button>
    </div>
  </form>
</div>

<?php include 'includes/footer.php'; ?>
