<?php
session_start();

include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$id = (int)($_GET['id'] ?? 0);
$meldung = '';
$user_einheit = $_SESSION['einheit'] ?? '';

// --- Kamerad laden (nur eigene Einheit) ---
$stmt = $conn->prepare("SELECT * FROM kameraden WHERE id = ? AND einheit = ?");
$stmt->bind_param("is", $id, $user_einheit);
$stmt->execute();
$kamerad = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$kamerad) {
    echo "<div class='container my-5'><div class='alert alert-danger'>Kamerad nicht gefunden oder gehört nicht zu deiner Einheit.</div></div>";
    include 'includes/footer.php';
    exit;
}

// --- Spind-Zuordnungen der EIGENEN Einheit prüfen ---
$spindnummern = range(1, 80);
$belegte_spinde = [];
$stmt = $conn->prepare("
    SELECT id, spindnr, vorname, nachname
    FROM kameraden
    WHERE id <> ? AND einheit = ? AND spindnr IS NOT NULL AND spindnr <> ''
");
$stmt->bind_param("is", $id, $user_einheit);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $belegte_spinde[$row['spindnr']] = $row['vorname'] . ' ' . $row['nachname'];
}
$stmt->close();

// --- Formular speichern ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])) {
    $vorname               = trim($_POST['vorname']);
    $nachname              = trim($_POST['nachname']);
    $email                 = trim($_POST['email']);
    $spindnr               = trim($_POST['spindnr']);
    $groesse_jacke         = trim($_POST['groesse_jacke']);
    $groesse_hose          = trim($_POST['groesse_hose']);
    $groesse_hose_agt      = trim($_POST['groesse_hose_agt']);
    $groesse_stiefel       = trim($_POST['groesse_stiefel']);
    $groesse_handschuhe    = trim($_POST['groesse_handschuhe']);
    $groesse_handschuhe_agt= trim($_POST['groesse_handschuhe_agt']);

    if ($spindnr !== '' && isset($belegte_spinde[$spindnr])) {
        $meldung = "<div class='alert alert-danger'>❌ Spind $spindnr ist bereits vergeben an {$belegte_spinde[$spindnr]}.</div>";
    } else {
        // Update nur innerhalb der eigenen Einheit zulassen
        $stmt = $conn->prepare("
            UPDATE kameraden
               SET vorname = ?, nachname = ?, email = ?, spindnr = ?,
                   groesse_jacke = ?, groesse_hose = ?, groesse_hose_agt = ?,
                   groesse_stiefel = ?, groesse_handschuhe = ?, groesse_handschuhe_agt = ?
             WHERE id = ? AND einheit = ?
        ");
        $stmt->bind_param(
            "ssssssssssis",
            $vorname, $nachname, $email, $spindnr,
            $groesse_jacke, $groesse_hose, $groesse_hose_agt,
            $groesse_stiefel, $groesse_handschuhe, $groesse_handschuhe_agt,
            $id, $user_einheit
        );
        $stmt->execute();
        $affected = $stmt->affected_rows;
        $stmt->close();

        if ($affected === 0) {
            $meldung = "<div class='alert alert-warning'>⚠️ Es wurden keine Änderungen gespeichert (evtl. keine Änderung oder fehlende Berechtigung).</div>";
        } else {
            $meldung = "<div class='alert alert-success'>✅ Kamerad erfolgreich aktualisiert.</div>";
        }

        // Reload Datensatz (wieder nur eigene Einheit)
        $stmt = $conn->prepare("SELECT * FROM kameraden WHERE id = ? AND einheit = ?");
        $stmt->bind_param("is", $id, $user_einheit);
        $stmt->execute();
        $kamerad = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        // Spindbelegung nach Update neu einlesen (falls sich was geändert hat)
        $belegte_spinde = [];
        $stmt = $conn->prepare("
            SELECT id, spindnr, vorname, nachname
            FROM kameraden
            WHERE id <> ? AND einheit = ? AND spindnr IS NOT NULL AND spindnr <> ''
        ");
        $stmt->bind_param("is", $id, $user_einheit);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $belegte_spinde[$row['spindnr']] = $row['vorname'] . ' ' . $row['nachname'];
        }
        $stmt->close();
    }
}
?>

<div class="container my-5">
  <h2 class="mb-4">Kamerad bearbeiten</h2>

  <?= $meldung ?>

  <form method="post" class="card p-4 bg-white shadow-sm">
    <div class="mb-3">
      <label class="form-label">Vorname</label>
      <input type="text" name="vorname" value="<?= htmlspecialchars($kamerad['vorname']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Nachname</label>
      <input type="text" name="nachname" value="<?= htmlspecialchars($kamerad['nachname']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">E-Mail</label>
      <input type="email" name="email" value="<?= htmlspecialchars($kamerad['email']) ?>" class="form-control">
    </div>
    <div class="mb-3">
      <label class="form-label">Spindnummer</label>
      <select name="spindnr" class="form-select" required>
        <option value="">– bitte wählen –</option>
        <?php foreach ($spindnummern as $nr): ?>
          <?php
            $ist_eigener = (string)$kamerad['spindnr'] === (string)$nr;
            $vergeben    = isset($belegte_spinde[$nr]);
            $text        = $vergeben ? " (vergeben an {$belegte_spinde[$nr]})" : '';
          ?>
          <option value="<?= $nr ?>"
            <?= $ist_eigener ? 'selected' : '' ?>
            <?= (!$ist_eigener && $vergeben) ? 'disabled' : '' ?>>
            <?= $nr . $text ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <h4 class="mb-4">Größen</h4>
    <div class="row g-3 mb-4">
      <div class="col-md-6">
        <label class="form-label">Einsatzjacke</label>
        <input type="text" name="groesse_jacke" value="<?= htmlspecialchars($kamerad['groesse_jacke']) ?>" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label">Einsatzhose</label>
        <input type="text" name="groesse_hose" value="<?= htmlspecialchars($kamerad['groesse_hose']) ?>" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label">Einsatzhose AGT</label>
        <input type="text" name="groesse_hose_agt" value="<?= htmlspecialchars($kamerad['groesse_hose_agt']) ?>" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label">Stiefel</label>
        <input type="text" name="groesse_stiefel" value="<?= htmlspecialchars($kamerad['groesse_stiefel']) ?>" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label">Handschuhe</label>
        <input type="text" name="groesse_handschuhe"
               value="<?= htmlspecialchars($kamerad['groesse_handschuhe']) ?>"
               class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label">Handschuhe AGT</label>
        <input type="text" name="groesse_handschuhe_agt"
               value="<?= htmlspecialchars($kamerad['groesse_handschuhe_agt']) ?>"
               class="form-control">
      </div>
    </div>

    <button type="submit" name="save" class="btn btn-primary">Speichern</button>
    <a href="kameraden.php" class="btn btn-outline-secondary ms-2">Zurück</a>
  </form>
</div>

<?php include 'includes/footer.php'; ?>
