<?php
session_start();

require __DIR__ . '/../includes/db.php';

// Simple Helper
function h($s){
    return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}

// Nur Root darf Passwörter zurücksetzen
if (!isset($_SESSION['user_id']) || ($_SESSION['root'] ?? 0) != 1) {
    echo "Kein Zugriff.";
    exit;
}

// ID aus GET
$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    echo "Ungültige ID.";
    exit;
}

// User-Daten holen (prepared)
$stmt = $conn->prepare("SELECT id, vorname, nachname, email, einheit FROM users WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    echo "Benutzer nicht gefunden.";
    exit;
}

// Neues Passwort erzeugen (8-stellig hex)
$neues_pw = bin2hex(random_bytes(4));
$hash = password_hash($neues_pw, PASSWORD_DEFAULT);

// Passwort speichern (prepared)
$upd = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
$upd->bind_param("si", $hash, $id);
$upd->execute();
$upd->close();

// Ausgabe im Browser
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Passwort zurückgesetzt</title>
    <style>
        body {
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background:#f5f5f5;
            padding:30px;
        }
        .box {
            max-width:600px;
            margin:0 auto;
            background:#fff;
            border-radius:12px;
            padding:20px 24px;
            box-shadow:0 4px 12px rgba(0,0,0,0.06);
        }
        h2 { margin-top:0; }
        .meta p { margin:4px 0; }
        .pw {
            font-size:26px;
            color:#c00;
            font-weight:bold;
            padding:10px 0;
            letter-spacing: 0.08em;
        }
        .hint {
            margin-top:10px;
            font-size:14px;
            color:#555;
        }
        .back {
            margin-top:20px;
        }
        .btn {
            display:inline-block;
            padding:8px 16px;
            border-radius:8px;
            background:#0d6efd;
            color:#fff;
            text-decoration:none;
        }
        .btn:hover {
            background:#0b5ed7;
        }
    </style>
</head>
<body>
<div class="box">
    <h2>Passwort zurückgesetzt</h2>

    <div class="meta">
        <p><strong>Benutzer:</strong> <?= h($user['vorname'].' '.$user['nachname']) ?></p>
        <p><strong>E-Mail:</strong> <?= h($user['email']) ?></p>
        <p><strong>Einheit:</strong> <?= h($user['einheit']) ?></p>
    </div>

    <p><strong>NEUES PASSWORT:</strong></p>
    <p class="pw"><?= h($neues_pw) ?></p>

    <p class="hint">
        Bitte notiere das Passwort und teile es dem Benutzer mit.
        Danach sollte er es im Profil direkt wieder ändern.
    </p>

    <div class="back">
        <a href="admin_users.php" class="btn">Zur Benutzerverwaltung</a>
    </div>
</div>
</body>
</html>
