<?php if (isset($_SESSION['user'])): ?>
  <?php
  $vorname = $_SESSION['user_vorname'] ?? '';
  $nachname = $_SESSION['user_nachname'] ?? '';
  $gemeinde = $_SESSION['gemeinde_id'] ?? '';
  $anzeige = trim($vorname . ' ' . $nachname);

  // Initialen für Avatar generieren
  $initials = strtoupper(substr($vorname, 0, 1) . substr($nachname, 0, 1));
  ?>

  <style>
    /* --- FIX: Schriftart global setzen --- */
    body {
        font-family: system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", "Liberation Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
    }

    .navbar-custom {
      background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%); /* Modern Dark Blue */
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
      padding-top: 0.75rem;
      padding-bottom: 0.75rem;
    }
    .navbar-brand {
      font-weight: 700;
      letter-spacing: -0.5px;
      font-size: 1.35rem;
    }
    .nav-link {
      font-size: 0.95rem;
      font-weight: 500;
      color: rgba(255,255,255,0.75) !important;
      transition: all 0.2s ease;
      display: flex;
      align-items: center;
      gap: 6px; /* Abstand Icon zu Text */
    }
    .nav-link:hover, .nav-link.show {
      color: #fff !important;
      transform: translateY(-1px);
    }
    .dropdown-menu {
      border: none;
      box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
      border-radius: 0.5rem;
      font-size: 0.9rem;
      margin-top: 10px;
    }
    .dropdown-item {
      padding: 8px 16px;
      border-radius: 4px;
      margin: 2px 4px;
      width: auto;
    }
    .dropdown-item:hover {
      background-color: #f1f5f9;
      color: #0f172a;
    }
    /* User Badge Styles */
    .user-badge {
      background: rgba(255,255,255,0.1);
      border-radius: 50px;
      padding: 4px 16px 4px 4px;
      display: flex;
      align-items: center;
      gap: 10px;
      border: 1px solid rgba(255,255,255,0.1);
    }
    .user-avatar {
      width: 36px;
      height: 36px;
      background: #3b82f6; /* Accent Blue */
      color: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: bold;
      font-size: 0.85rem;
    }
    .user-info {
      line-height: 1.1;
      text-align: left;
    }
    .user-name { font-size: 0.85rem; font-weight: 600; color: #fff; }
    .user-unit { font-size: 0.7rem; color: rgba(255,255,255,0.6); }
  </style>

  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

  <nav class="navbar navbar-expand-xl navbar-dark navbar-custom sticky-top">
    <div class="container-fluid">

      <a class="navbar-brand d-flex align-items-center gap-2" href="../index.php">
        <i class="bi bi-cloud-haze2 text-primary"></i>
        <span>cloud.F-Invent</span>
      </a>

      <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbarNav">
        <ul class="navbar-nav mx-auto"> <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-house-door"></i> Start
            </a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="../favoriten.php"><i class="bi bi-star me-2 text-warning"></i>Favoriten</a></li>
            </ul>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-tools"></i> Technik
            </a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="../atemschutz.php">Atemschutz</a></li>
              <li><a class="dropdown-item" href="../fahrzeuge.php">Fahrzeuge</a></li>
              <li><a class="dropdown-item" href="../geraete.php">Geräte</a></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item" href="../geraete_stats.php">Statistik</a></li>
              <li><a class="dropdown-item" href="../transponder.php">Transponder</a></li>
              <li><a class="dropdown-item" href="../melder.php">Melder</a></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item" href="../inventur_liste.php">Inventur</a></li>
              <li><a class="dropdown-item text-danger" href="../papierkorb.php"><i class="bi bi-trash me-2"></i>Papierkorb</a></li>
            </ul>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-pc-display"></i> IT
            </a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="../it_assets.php">Assets</a></li>
              <li><a class="dropdown-item" href="it_passwords.php">Zugänge</a></li>
              <li><a class="dropdown-item" href="#">Netzwerk</a></li>
            </ul>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-person-gear"></i> PSA
            </a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="../kameraden.php">Stammdaten</a></li>
              <li><a class="dropdown-item" href="../psa.php">PSA Verwaltung</a></li>
              <li><a class="dropdown-item" href="../psa_stats.php">Statistiken</a></li>
            </ul>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-box-seam"></i> Lager
            </a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="../lager.php">Lagerbestand</a></li>
              <li><a class="dropdown-item" href="../lieferschein_neu.php">Neuer Lieferschein</a></li>
              <li><a class="dropdown-item" href="../lieferschein_liste.php">Lieferscheine</a></li>
            </ul>
          </li>

          <li class="nav-item dropdown">
             <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
               <i class="bi bi-cart"></i> Bestellwesen
             </a>
             <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="../cart.php">Warenkorb</a></li>
             </ul>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-folder2-open"></i> Dokumente
            </a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="../dokumente.php">DMS</a></li>
            </ul>
          </li>

          <li class="nav-item">
             <a class="nav-link" href="../tickets.php" title="Tickets">
                <i class="bi bi-ticket-perforated"></i> <span class="d-xl-none d-xxl-inline">Tickets</span>
             </a>
          </li>
          <li class="nav-item">
             <a class="nav-link" href="../aufgaben.php" title="Aufgaben">
                <i class="bi bi-list-check"></i> <span class="d-xl-none d-xxl-inline">Aufgaben</span>
             </a>
          </li>
          <li class="nav-item">
             <a class="nav-link" href="../chat.php" title="Chat">
                <i class="bi bi-chat-dots"></i> <span class="d-xl-none d-xxl-inline">Chat</span>
             </a>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
              <i class="bi bi-gear"></i> Admin
            </a>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="../account.php">Mein Account</a></li>
              <li><a class="dropdown-item" href="../einheit.php">Meine Einheit</a></li>
              <li><a class="dropdown-item" href="../zeiterfassung.php">Zeiterfassung</a></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item" href="../einstellungen.php">System-Einstellungen</a></li>
            </ul>
          </li>
        </ul>

        <div class="d-flex align-items-center mt-3 mt-xl-0 ms-xl-3">
           <div class="user-badge me-2">
              <div class="user-avatar">
                 <?= $initials ?>
              </div>
              <div class="user-info d-none d-sm-block">
                 <div class="user-name"><?= htmlspecialchars($vorname) ?></div>
                 <div class="user-unit"><?= htmlspecialchars($gemeinde) ?></div>
              </div>
           </div>
           <a href="../logout.php" class="btn btn-outline-light btn-sm border-0" title="Abmelden">
              <i class="bi bi-box-arrow-right fs-5"></i>
           </a>
        </div>

      </div>
    </div>
  </nav>
<?php endif; ?>
