<?php
// it_asset_detail.php – Detailseite für ein IT-Asset
ob_start();
session_start();

require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
require_once __DIR__ . '/includes/db.php';

if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit; }

$user_id      = (int)$_SESSION['user_id'];
$user_einheit = $_SESSION['einheit'] ?? '';
$user_rechte  = (int)($_SESSION['is_admin'] ?? 0);

if ($user_einheit === '') {
  echo "<div class='container my-5'><div class='alert alert-warning'>⚠️ Keine Einheit in der Session gefunden. Bitte erneut einloggen.</div></div>";
  include 'includes/footer.php'; exit;
}

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

// ---------------- ID holen ----------------
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  echo "<div class='container my-5'><div class='alert alert-danger'>❌ Ungültige ID.</div></div>";
  include 'includes/footer.php'; ob_end_flush(); exit;
}

// ---------------- Asset laden (nur eigene Einheit) ----------------
$st = $conn->prepare("SELECT * FROM it_assets WHERE id = ? AND einheit = ? LIMIT 1");
$st->bind_param("is", $id, $user_einheit);
$st->execute();
$res = $st->get_result();
$asset = $res->fetch_assoc();

if (!$asset) {
  echo "<div class='container my-5'><div class='alert alert-danger'>❌ IT-Asset nicht gefunden oder keine Berechtigung.</div></div>";
  include 'includes/footer.php'; ob_end_flush(); exit;
}

// Status-Badge
$status = $asset['status'] ?? '';
$badgeClass = 'bg-secondary';
if ($status === 'aktiv' || $status === 'in Nutzung') $badgeClass = 'bg-success';
elseif ($status === 'in Reparatur' || $status === 'Reparatur') $badgeClass = 'bg-warning text-dark';
elseif ($status === 'defekt') $badgeClass = 'bg-danger';
elseif ($status === 'ausgemustert') $badgeClass = 'bg-dark';
elseif ($status === 'Lager') $badgeClass = 'bg-info text-dark';

?>
<style>
  .text-mono{font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono","Courier New",monospace;}
  .asset-meta{font-size:.9rem;color:#6c757d}
  .detail-label{font-size:.8rem;text-transform:uppercase;color:#6c757d;margin-bottom:2px;}
  .detail-value{font-size:1rem;}
</style>

<div class="container my-5">

  <!-- Kopfzeile -->
  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <div class="mb-1">
        <a href="it_assets.php" class="btn btn-sm btn-outline-secondary">&laquo; Zurück zur Übersicht</a>
      </div>
      <h2 class="mb-0">
        <?= h($asset['bezeichnung']) ?>
      </h2>
      <div class="asset-meta">
        <span class="text-mono"><?= h($asset['asset_tag']) ?></span> ·
        Kategorie: <?= h($asset['kategorie']) ?> ·
        Einheit: <span class="badge text-bg-secondary"><?= h($asset['einheit']) ?></span>
      </div>
    </div>
    <div class="text-end">
      <div class="mb-2">
        <span class="badge <?= $badgeClass ?>"><?= h($status) ?></span>
      </div>
      <a href="it_assets.php?search=<?= urlencode($asset['asset_tag']) ?>"
         class="btn btn-sm btn-outline-primary">
        In Liste anzeigen
      </a>
    </div>
  </div>

  <!-- Content -->
  <div class="row g-4">
    <!-- Linke Spalte: Stammdaten -->
    <div class="col-md-7">
      <div class="card shadow-sm mb-3">
        <div class="card-header bg-light">
          <strong>Stammdaten</strong>
        </div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-md-6">
              <div class="detail-label">Asset-Tag</div>
              <div class="detail-value text-mono"><?= h($asset['asset_tag']) ?></div>
            </div>
            <div class="col-md-6">
              <div class="detail-label">Bezeichnung</div>
              <div class="detail-value"><?= h($asset['bezeichnung']) ?></div>
            </div>
            <div class="col-md-6">
              <div class="detail-label">Kategorie</div>
              <div class="detail-value"><?= h($asset['kategorie']) ?></div>
            </div>
            <div class="col-md-6">
              <div class="detail-label">Status</div>
              <div class="detail-value">
                <span class="badge <?= $badgeClass ?>"><?= h($status) ?></span>
              </div>
            </div>

            <div class="col-md-6">
              <div class="detail-label">Hersteller</div>
              <div class="detail-value"><?= h($asset['hersteller']) ?></div>
            </div>
            <div class="col-md-6">
              <div class="detail-label">Modell</div>
              <div class="detail-value"><?= h($asset['modell']) ?></div>
            </div>

            <div class="col-md-6">
              <div class="detail-label">Seriennummer</div>
              <div class="detail-value text-mono"><?= h($asset['seriennummer']) ?></div>
            </div>

            <div class="col-md-6">
              <div class="detail-label">Erstellt am</div>
              <div class="detail-value">
                <?= h($asset['created_at']) ?>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Standort / Zuordnung -->
      <div class="card shadow-sm mb-3">
        <div class="card-header bg-light">
          <strong>Standort & Zuordnung</strong>
        </div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-md-6">
              <div class="detail-label">Standort</div>
              <div class="detail-value"><?= h($asset['standort']) ?></div>
            </div>
            <div class="col-md-6">
              <div class="detail-label">Zugewiesen an</div>
              <div class="detail-value"><?= h($asset['zugewiesen_an']) ?></div>
            </div>
          </div>
        </div>
      </div>

      <!-- Bemerkung -->
      <div class="card shadow-sm mb-3">
        <div class="card-header bg-light">
          <strong>Bemerkung</strong>
        </div>
        <div class="card-body">
          <?php if (trim((string)$asset['bemerkung']) !== ''): ?>
            <p class="mb-0" style="white-space: pre-wrap;"><?= h($asset['bemerkung']) ?></p>
          <?php else: ?>
            <p class="text-muted mb-0">Keine Bemerkung hinterlegt.</p>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- Rechte Spalte: Aktionen / (später Historie, Tickets, Dateien) -->
    <div class="col-md-5">
      <div class="card shadow-sm mb-3">
        <div class="card-header bg-light">
          <strong>Aktionen</strong>
        </div>
        <div class="card-body d-grid gap-2">
          <!-- Bearbeiten via Modal der Listen-Seite oder eigene Edit-Seite -->
          <a href="it_assets.php?search=<?= urlencode($asset['asset_tag']) ?>"
             class="btn btn-outline-primary">
            In Übersicht bearbeiten / öffnen
          </a>

          <?php if ($user_rechte >= 1): ?>
            <a href="it_assets.php?<?= http_build_query(['delete'=>$asset['id']]) ?>"
               class="btn btn-outline-danger"
               onclick="return confirm('❗ Dieses IT-Asset wirklich löschen?');">
              Löschen
            </a>
          <?php endif; ?>
        </div>
      </div>

      <!-- Platzhalter für Historie, z. B. Umbuchungen, Reparaturen, Tickets -->
      <div class="card shadow-sm">
        <div class="card-header bg-light">
          <strong>Historie / Notizen</strong>
        </div>
        <div class="card-body">
          <p class="text-muted mb-0">
            Hier kannst du später z. B. eine Wartungs- oder Umbuchungshistorie für dieses Asset anzeigen
            (ähnlich wie bei deinen Geräten / Lagerbewegungen).
          </p>
        </div>
      </div>
    </div>
  </div>

</div>

<?php
include 'includes/footer.php';
ob_end_flush();
?>
