<?php
// lieferschein_speichern.php
session_start();
require_once __DIR__ . '/includes/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$einheit = $_SESSION['einheit'] ?? '';
$user_id = (int)$_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // 1. Daten aus dem Formular holen
    $lieferdatum = $_POST['lieferdatum'] ?? date('Y-m-d');
    $adresse_id  = (int)($_POST['adresse_id'] ?? 0);
    $empfaenger  = trim($_POST['empfaenger'] ?? '');
    $hinweis     = trim($_POST['hinweis'] ?? ''); // <--- DAS IST NEU

    // Arrays für Geräte und Freie Positionen
    $geraeteIds  = $_POST['geraete'] ?? [];

    $freie_bez   = $_POST['freie_bezeichnung'] ?? [];
    $freie_menge = $_POST['freie_menge'] ?? [];
    $freie_bem   = $_POST['freie_bemerkung'] ?? [];

    if ($adresse_id <= 0) {
        die("Fehler: Keine gültige Adresse gewählt.");
    }

    // 2. Lieferschein Kopfdaten anlegen
    // Wir fügen 'hinweis' zum INSERT hinzu
    $stmt = $conn->prepare("INSERT INTO lieferscheine (einheit, erstellt_von, lieferdatum, adresse_id, empfaenger, hinweis, status, erstellt_am) VALUES (?, ?, ?, ?, ?, ?, 'Offen', NOW())");
    $stmt->bind_param("sisiss", $einheit, $user_id, $lieferdatum, $adresse_id, $empfaenger, $hinweis);

    if ($stmt->execute()) {
        $lieferschein_id = $stmt->insert_id;
        $stmt->close();

        // 3. Ausgewählte Geräte speichern
        if (!empty($geraeteIds)) {
            $stmtG = $conn->prepare("INSERT INTO lieferschein_geraete (lieferschein_id, geraet_id) VALUES (?, ?)");
            foreach ($geraeteIds as $gId) {
                $gId = (int)$gId;
                if ($gId > 0) {
                    $stmtG->bind_param("ii", $lieferschein_id, $gId);
                    $stmtG->execute();
                }
            }
            $stmtG->close();
        }

        // 4. Freie Positionen speichern
        if (!empty($freie_bez)) {
            $stmtP = $conn->prepare("INSERT INTO lieferschein_positionen (lieferschein_id, bezeichnung, menge, bemerkung) VALUES (?, ?, ?, ?)");

            for ($i = 0; $i < count($freie_bez); $i++) {
                $b = trim($freie_bez[$i]);
                $m = trim($freie_menge[$i] ?? '');
                $x = trim($freie_bem[$i] ?? '');

                // Nur speichern, wenn Bezeichnung nicht leer ist
                if ($b !== '') {
                    $stmtP->bind_param("isss", $lieferschein_id, $b, $m, $x);
                    $stmtP->execute();
                }
            }
            $stmtP->close();
        }

        // 5. Weiterleitung zur Druckansicht
        // (Hier leiten wir auf die Datei weiter, die wir im vorletzten Schritt für den Druck erstellt haben)
        header("Location: lieferschein_druck.php?id=" . $lieferschein_id);
        exit;

    } else {
        echo "Fehler beim Speichern des Lieferscheins: " . $conn->error;
    }

} else {
    header("Location: lieferschein_neu.php");
    exit;
}
