<?php
session_start();

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'];
$timestamp = time();
$date = date("Y-m-d");
$month = date("Y-m");

// Besucherdaten-Datei
$file = 'visitors.json';
$data = file_exists($file) ? json_decode(file_get_contents($file), true) : [];

// Neuen Eintrag hinzufügen oder aktualisieren
$data['visitors'][$ip] = [
    'ip' => $ip,
    'user_agent' => $userAgent,
    'last_seen' => $timestamp,
    'date' => $date,
    'month' => $month
];

// Tages- und Monatszählung aktualisieren
if (!isset($data['stats']['daily'][$date])) {
    $data['stats']['daily'][$date] = 0;
}
if (!isset($data['stats']['monthly'][$month])) {
    $data['stats']['monthly'][$month] = 0;
}

$data['stats']['daily'][$date]++;
$data['stats']['monthly'][$month]++;

// Datei aktualisieren
file_put_contents($file, json_encode($data));

// Passwort definieren
$correct_password = "A2BZ";

// Überprüfen, ob das Passwort bereits in der Session gespeichert wurde
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["password"])) {
        if ($_POST["password"] === $correct_password) {
            $_SESSION['logged_in'] = true;
            header("Location: index.php");
            exit;
        } else {
            $error = "❌ Falsches Passwort!";
        }
    }

    // Falls nicht eingeloggt, Passwortabfrage anzeigen
    ?>
    <!DOCTYPE html>
    <html lang="de">
    <head>
        <meta name="robots" content="noindex, nofollow">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Archiv Dienstagsmail</title>
        <style>
            body { font-family: Arial, sans-serif; text-align: center; margin-top: 100px; background-color: #f4f4f4; }
            .login-container {
                background: white; padding: 20px; border-radius: 8px;
                box-shadow: 0px 4px 10px rgba(0,0,0,0.1); display: inline-block;
            }
            input, button {
                padding: 10px; margin-top: 10px; border-radius: 5px;
                border: 1px solid #ccc; width: 200px;
            }
            button { background: #007aff; color: white; cursor: pointer; }
            button:hover { background: #0056b3; }
            .error { color: red; margin-top: 10px; }
        </style>
    </head>
    <body>
        <div class="login-container">
            <h2>🔒 Passwort erforderlich</h2>
            <form method="post">
                <input type="password" name="password" placeholder="Passwort eingeben" required><br>
                <button type="submit">Login</button>
            </form>
            <?php if (isset($error)) echo "<p class='error'>$error</p>"; ?>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Datei-Browser Code
$baseDir = 'uploads';
$currentDir = isset($_GET['dir']) ? realpath($baseDir . '/' . $_GET['dir']) : realpath($baseDir);
if (strpos($currentDir, realpath($baseDir)) !== 0) { $currentDir = realpath($baseDir); }
$items = scandir($currentDir);
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <link rel="icon" type="image/png" href="cloud.ico">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dienstagsmail Archiv</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            font-family: "SF Pro Display", Arial, sans-serif; text-align: center;
            margin: 0; padding: 20px; background: linear-gradient(135deg, #ffeb3b, #ff9800);
        }
        .container {
            max-width: 750px; margin: auto; background: white;
            border-radius: 15px; box-shadow: 0px 6px 15px rgba(0,0,0,0.15);
            padding: 20px;
        }
        h2 { font-size: 24px; margin-bottom: 10px; color: #333; }
        .file-browser {
            display: flex; flex-wrap: wrap; gap: 15px; justify-content: center;
        }
        .file-item {
            display: flex; flex-direction: column; align-items: center;
            width: 120px; padding: 10px; border-radius: 10px;
            transition: all 0.3s ease-in-out; cursor: pointer; text-align: center;
            background: linear-gradient(135deg, #f1f1f1, #fff);
            box-shadow: 0px 4px 8px rgba(0,0,0,0.1);
        }
        .file-item:hover {
            transform: scale(1.05);
            box-shadow: 0px 5px 15px rgba(0,0,0,0.2);
        }
        .file-item i { font-size: 50px; margin-bottom: 5px; color: #007aff; }
        .file-name {
            font-size: 14px; color: #333; font-weight: bold;
            white-space: nowrap; overflow: hidden; text-overflow: ellipsis; width: 100%;
        }
        .button {
            background: linear-gradient(135deg, #007aff, #004fbd);
            color: white; padding: 12px 20px; border: none; cursor: pointer;
            font-size: 16px; border-radius: 8px; width: 90%; max-width: 400px; margin: 10px; display: block;
        }
        .button:hover { background: linear-gradient(135deg, #0056b3, #003f7f); }
        /* Impressum */
        .impressum {
            margin-top: 20px; padding: 15px; background: #f8f8f8; border-top: 1px solid #ddd;
            font-size: 14px; text-align: center;
        }
        .impressum a { color: #007aff; text-decoration: none; }
        .impressum a:hover { text-decoration: underline; }
    </style>
</head>
<body>

    <div class="container">
        <h2>📂 Archiv Dienstagsmail</h2>
        <div class="file-browser">
            <?php
            if ($currentDir !== realpath($baseDir)) {
                echo '<div class="file-item" onclick="window.location.href=\'?dir=' . urlencode(dirname($_GET['dir'])) . '\'">
                        <i class="fas fa-arrow-left"></i>
                      </div>';
            }
            foreach ($items as $item) {
                if ($item === '.' || $item === '..') continue;
                $path = $currentDir . '/' . $item;
                $relativePath = str_replace(realpath($baseDir) . '/', '', $path);

                if (is_dir($path)) {
                    echo '<div class="file-item" onclick="window.location.href=\'?dir=' . urlencode($relativePath) . '\'">
                            <i class="fas fa-folder" style="color: #f1c40f;"></i>
                            <div class="file-name">' . $item . '</div>
                          </div>';
                } else {
                    echo '<div class="file-item" onclick="window.open(\'' . $baseDir . '/' . $relativePath . '\', \'_blank\')">
                            <i class="fas fa-file"></i>
                            <div class="file-name">' . $item . '</div>
                          </div>';
                }
            }
            ?>
        </div>
    </div>

    <!-- 🔽 Impressum unterhalb des Containers -->
    <div class="impressum">
        <p>Fragen? Erstelle eine Anfrage im <br><a target="_blank" href="https://cloud.f-invent.de/ticket/ticket.php">Ticketsystem!</a></p>
    </div>

</body>
</html>
