<?php
session_start();
include 'includes/db.php';

$result = $conn->query("
  SELECT c.*, u.vorname, u.nachname
  FROM chat_nachrichten c
  JOIN users u ON u.id = c.user_id
  ORDER BY c.zeit DESC
  LIMIT 50
");

$nachrichten = [];
while ($row = $result->fetch_assoc()) {
    $zeit = date('H:i', strtotime($row['zeit']));
    $name = htmlspecialchars($row['vorname'] . ' ' . $row['nachname']);
    $text = nl2br(htmlspecialchars($row['nachricht']));
    echo "<div class='nachricht'><b>$name</b> <span class='zeit'>[$zeit]</span><br>$text</div>";
}
