<?php
ob_start();
session_start();
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

// Zugriffsschutz
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Einheit des eingeloggten Benutzers
$user_einheit = $_SESSION['einheit'] ?? '';

// Rückmeldungen
$success = false;
$fehler = false;
$fehlertext = '';

// Formularverarbeitung
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $gemeinde_id = $_POST['gemeinde'] ?? '';
    $einheit = $_POST['einheit'] ?? '';
    $fahrzeug = $_POST['fahrzeug'] ?? '';
    $bezeichnung = $_POST['bezeichnung'] ?? '';
    $barcode = $_POST['barcode'] ?? '';
    $kat = $_POST['kat'] ?? '';
    $baujahr = $_POST['baujahr'] ?? null;
    $gr = $_POST['gr'] ?? '';
    $status = $_POST['status'] ?? '';
    $lpruefung = strtotime($_POST['lpruefung'] ?? '');

    // 🔝 Barcode-Prüfung auf Dopplung innerhalb der Einheit
    $stmt_check = $conn->prepare("SELECT id FROM ffw_geraete WHERE barcode = ? AND einheit = ?");
    $stmt_check->bind_param("ss", $barcode, $einheit);
    $stmt_check->execute();
    $check_result = $stmt_check->get_result();

    if ($check_result->num_rows > 0) {
        $fehler = true;
        $fehlertext = "Der Barcode <strong>" . htmlspecialchars($barcode) . "</strong> ist in der Einheit <strong>" . htmlspecialchars($einheit) . "</strong> bereits vergeben.";
    } else {
        $sql = "INSERT INTO ffw_geraete (gemeinde_id, einheit, fahrzeug, bezeichnung, barcode, kat, baujahr, gr, status, lpruefung)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("isssssssii", $gemeinde_id, $einheit, $fahrzeug, $bezeichnung, $barcode, $kat, $baujahr, $gr, $status, $lpruefung);

        if ($stmt->execute()) {
            $success = true;
        }
    }
}

// Einheiten + Gemeinde-ID aus Tabelle users
$einheiten = [];
$sql = "SELECT DISTINCT einheit, gemeinde_id FROM users WHERE einheit IS NOT NULL AND einheit != '' ORDER BY einheit ASC";
$result = $conn->query($sql);
while ($row = $result->fetch_assoc()) {
    $einheiten[] = $row;
}

// Fahrzeuge nur aus der Einheit des eingeloggten Benutzers
$stmtFzg = $conn->prepare("SELECT barcode_fzg, fahrzeugbezeichnung FROM ffw_fahrzeuge WHERE einheit = ? ORDER BY fahrzeugbezeichnung ASC");
$stmtFzg->bind_param("s", $user_einheit);
$stmtFzg->execute();
$fahrzeuge = $stmtFzg->get_result();

// Dropdown-Werte DISTINCT laden
$kategorien = $conn->query("SELECT DISTINCT kat FROM ffw_geraete WHERE kat IS NOT NULL AND kat != '' ORDER BY kat ASC");
$geraeteraeume = $conn->query("SELECT DISTINCT gr FROM ffw_geraete WHERE gr IS NOT NULL AND gr != '' ORDER BY gr ASC");
$statuswerte = $conn->query("SELECT DISTINCT status FROM ffw_geraete WHERE status IS NOT NULL AND status != '' ORDER BY status ASC");
?>

<div class="container mt-5">
    <h1 class="mb-4">Geräteverwaltung</h1>

    <?php if ($fehler): ?>
        <div class="alert alert-danger"><?= $fehlertext ?></div>
    <?php endif; ?>

    <?php if ($success): ?>
        <div class="alert alert-success">Gerät erfolgreich hinzugefügt.</div>
    <?php endif; ?>

    <button class="btn btn-primary mb-4" data-bs-toggle="modal" data-bs-target="#geraeteModal">
        ➕ Gerät hinzufügen
    </button>

    <!-- Modal -->
    <div class="modal fade" id="geraeteModal" tabindex="-1" aria-labelledby="geraeteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <form method="post" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="geraeteModalLabel">Neues Gerät anlegen</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Schließen"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Einheit</label>
                            <select name="einheit" id="einheit" class="form-select" required onchange="setGemeinde(this.value)">
                                <option value="">Bitte wählen</option>
                                <?php foreach ($einheiten as $e): ?>
                                    <option value="<?= htmlspecialchars($e['einheit']) ?>" <?= ($_POST['einheit'] ?? '') === $e['einheit'] ? 'selected' : '' ?>><?= htmlspecialchars($e['einheit']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Gemeinde-ID</label>
                            <input type="text" name="gemeinde" id="gemeinde" class="form-control" readonly value="<?= htmlspecialchars($_POST['gemeinde'] ?? '') ?>">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Fahrzeug</label>
                        <select name="fahrzeug" class="form-select" required>
                            <option value="">Bitte wählen</option>
                            <?php while ($f = $fahrzeuge->fetch_assoc()): ?>
                                <option value="<?= htmlspecialchars($f['barcode_fzg']) ?>" <?= ($_POST['fahrzeug'] ?? '') === $f['barcode_fzg'] ? 'selected' : '' ?>><?= htmlspecialchars($f['fahrzeugbezeichnung']) ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Bezeichnung</label>
                            <input type="text" name="bezeichnung" class="form-control" required value="<?= htmlspecialchars($_POST['bezeichnung'] ?? '') ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Barcode</label>
                            <input type="text" name="barcode" class="form-control" required value="<?= htmlspecialchars($_POST['barcode'] ?? '') ?>">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label">Kategorie</label>
                            <select name="kat" class="form-select">
                                <option value="">Bitte wählen</option>
                                <?php while ($k = $kategorien->fetch_assoc()): ?>
                                    <option value="<?= htmlspecialchars($k['kat']) ?>" <?= ($_POST['kat'] ?? '') === $k['kat'] ? 'selected' : '' ?>><?= htmlspecialchars($k['kat']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Geräteraum (GR)</label>
                            <select name="gr" class="form-select">
                                <option value="">Bitte wählen</option>
                                <?php while ($g = $geraeteraeume->fetch_assoc()): ?>
                                    <option value="<?= htmlspecialchars($g['gr']) ?>" <?= ($_POST['gr'] ?? '') === $g['gr'] ? 'selected' : '' ?>><?= htmlspecialchars($g['gr']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select">
                                <option value="">Bitte wählen</option>
                                <?php while ($s = $statuswerte->fetch_assoc()): ?>
                                    <option value="<?= htmlspecialchars($s['status']) ?>" <?= ($_POST['status'] ?? '') === $s['status'] ? 'selected' : '' ?>><?= htmlspecialchars($s['status']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Letzte Prüfung</label>
                            <input type="date" name="lpruefung" class="form-control" value="<?= htmlspecialchars($_POST['lpruefung'] ?? '') ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Baujahr</label>
                            <input type="number" name="baujahr" class="form-control" min="1900" max="<?= date('Y') ?>" placeholder="z. B. 2020" value="<?= htmlspecialchars($_POST['baujahr'] ?? '') ?>">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">📂 Speichern</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Zuordnung Einheit → Gemeinde-ID aus PHP
const einheitZuGemeinde = <?= json_encode(array_column($einheiten, 'gemeinde_id', 'einheit')) ?>;

function setGemeinde(einheit) {
    document.getElementById('gemeinde').value = einheitZuGemeinde[einheit] ?? '';
}
</script>

<?php if ($fehler): ?>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const modal = new bootstrap.Modal(document.getElementById('geraeteModal'));
        modal.show();
    });
</script>
<?php endif; ?>

<?php include 'includes/footer.php'; ob_end_flush(); ?>
