<?php
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

$einheit = $_SESSION['einheit'] ?? '';
$filter_fahrzeug = $_GET['fahrzeug'] ?? '';
$filter_kat = $_GET['kat'] ?? '';

// Fahrzeuge für Filter-Dropdown
$stmtFzg = $conn->prepare("SELECT DISTINCT barcode_fzg, fahrzeugbezeichnung FROM ffw_fahrzeuge WHERE einheit = ? ORDER BY fahrzeugbezeichnung ASC");
$stmtFzg->bind_param("s", $einheit);
$stmtFzg->execute();
$fzg_result = $stmtFzg->get_result();

// Kategorien für Filter
$kat_result = $conn->query("SELECT DISTINCT kat FROM ffw_geraete WHERE einheit = '$einheit' AND status != 'Ausgesondert' AND kat != '' ORDER BY kat ASC");

// Geräte laden
$sql = "
    SELECT g.*, f.fahrzeugbezeichnung
    FROM ffw_geraete g
    LEFT JOIN ffw_fahrzeuge f ON g.fahrzeug = f.barcode_fzg
    WHERE g.einheit = ?
    AND g.status != 'Ausgesondert'
    AND g.lpruefung < UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 11 MONTH))
";

$params = [$einheit];
$types = "s";

if (!empty($filter_fahrzeug)) {
    $sql .= " AND g.fahrzeug = ?";
    $params[] = $filter_fahrzeug;
    $types .= "s";
}
if (!empty($filter_kat)) {
    $sql .= " AND g.kat = ?";
    $params[] = $filter_kat;
    $types .= "s";
}
$sql .= " ORDER BY g.lpruefung ASC";

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$geräte = $stmt->get_result();
?>

<div class="container mt-5">
    <h1 class="mb-4">🔔 Bald fällige Prüfungen</h1>
    <a href="dashboard.php" class="btn btn-secondary mb-4">🔙 Zurück zum Dashboard</a>

    <!-- Filter -->
    <form method="get" class="row g-3 mb-4">
        <div class="col-md-4">
            <label for="fahrzeug" class="form-label">Fahrzeug</label>
            <select name="fahrzeug" id="fahrzeug" class="form-select">
                <option value="">Alle Fahrzeuge</option>
                <?php while ($f = $fzg_result->fetch_assoc()): ?>
                    <option value="<?= $f['barcode_fzg'] ?>" <?= $filter_fahrzeug == $f['barcode_fzg'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($f['fahrzeugbezeichnung']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-md-4">
            <label for="kat" class="form-label">Kategorie</label>
            <select name="kat" id="kat" class="form-select">
                <option value="">Alle Kategorien</option>
                <?php while ($k = $kat_result->fetch_assoc()): ?>
                    <option value="<?= $k['kat'] ?>" <?= $filter_kat == $k['kat'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($k['kat']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-md-4 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">🔍 Filtern</button>
        </div>
    </form>

    <!-- Tabelle -->
    <?php if ($geräte->num_rows > 0): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-sm align-middle text-center">
                <thead class="table-light">
                    <tr>
                        <th>Bezeichnung</th>
                        <th>Barcode</th>
                        <th>Kategorie</th>
                        <th>Fahrzeug</th>
                        <th>Letzte Prüfung</th>
                        <th>Nächste Prüfung</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $geräte->fetch_assoc()): ?>
                        <?php
                            $nächste = strtotime('+1 year', $row['lpruefung']);
                            $tage_diff = floor(($nächste - time()) / (60 * 60 * 24));
                            $bg = 'table-success';
                            if ($tage_diff < 7) $bg = 'table-danger';
                            elseif ($tage_diff < 30) $bg = 'table-warning';
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($row['bezeichnung']) ?></td>
                            <td><?= htmlspecialchars($row['barcode']) ?></td>
                            <td><?= htmlspecialchars($row['kat']) ?></td>
                            <td><?= htmlspecialchars($row['fahrzeugbezeichnung'] ?? '-') ?></td>
                            <td><?= date("d.m.Y", $row['lpruefung']) ?></td>
                            <td class="<?= $bg ?>"><?= date("d.m.Y", $nächste) ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info">Keine fälligen Prüfungen gefunden.</div>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
