<?php
include '../includes/header.php';
include '../includes/nav.php';
?>

<div class="container my-5">
  <h1 class="mb-4 text-center">📚 Hilfe & Support</h1>
  <p class="lead text-center mb-5">Willkommen im Hilfeportal. Hier findest du Anleitungen, Tipps und Antworten zu allen Modulen deines Programms.</p>

  <div class="row row-cols-1 row-cols-md-2 g-4">
    <!-- PSA Verwaltung -->
    <div class="col">
      <div class="card h-100 shadow-sm">
        <div class="card-body d-flex flex-column">
          <h5 class="card-title">🦺 PSA-Verwaltung</h5>
          <p class="card-text flex-grow-1">Anlegen, Bearbeiten und Verwalten von persönlicher Schutzausrüstung (PSA).</p>
          <a href="help_psa.php" class="btn btn-primary w-100 mt-auto">Zur Hilfe</a>
        </div>
      </div>
    </div>

    <!-- Geräteverwaltung -->
    <div class="col">
      <div class="card h-100 shadow-sm">
        <div class="card-body d-flex flex-column">
          <h5 class="card-title">🛠 Geräteverwaltung</h5>
          <p class="card-text flex-grow-1">Wie Geräte erfasst, geprüft und gewartet werden.</p>
          <a href="help_geraete.php" class="btn btn-outline-secondary w-100 mt-auto disabled">In Vorbereitung</a>
        </div>
      </div>
    </div>

    <!-- Zeiterfassung -->
    <div class="col">
      <div class="card h-100 shadow-sm">
        <div class="card-body d-flex flex-column">
          <h5 class="card-title">⏱ Zeiterfassung</h5>
          <p class="card-text flex-grow-1">Start-/Stopp-Zeiten, manuelle Eingaben und Auswertungen.</p>
          <a href="help_zeit.php" class="btn btn-outline-secondary w-100 mt-auto disabled">In Vorbereitung</a>
        </div>
      </div>
    </div>

    <!-- Lagerverwaltung -->
    <div class="col">
      <div class="card h-100 shadow-sm">
        <div class="card-body d-flex flex-column">
          <h5 class="card-title">📦 Lager & Material</h5>
          <p class="card-text flex-grow-1">Verwaltung von Artikeln, Lagerbewegungen und Mindestbeständen.</p>
          <a href="help_lager.php" class="btn btn-outline-secondary w-100 mt-auto disabled">In Vorbereitung</a>
        </div>
      </div>
    </div>

    <!-- Atemschutzgeräte -->
    <div class="col">
      <div class="card h-100 shadow-sm">
        <div class="card-body d-flex flex-column">
          <h5 class="card-title">🧯 Atemschutzgeräte</h5>
          <p class="card-text flex-grow-1">Geräte anlegen, Prüfungen dokumentieren und Historie einsehen.</p>
          <a href="atemschutz_hilfe.php" class="btn btn-primary w-100 mt-auto">Zur Hilfe</a>
        </div>
      </div>
    </div>
  </div>

  <div class="mt-5 text-center">
    <p class="text-muted">❓ Noch Fragen? Sende eine Nachricht an <a href="mailto:support@dein-system.de">support@dein-system.de</a> oder nutze das <a href="feedback.php">Feedback-Formular</a>.</p>
  </div>
</div>

<?php include '../includes/footer.php'; ?>
