<?php
// ==========================================
// ⚙️ KONFIGURATION
// ==========================================

// 1. Lokale Pfade
$sourceFolder = '/home2/kd54698/app.f-invent.de';        // Quellordner
$backupFolder = '/home2/kd54698/io.f-invent.de/backup';  // Lokaler Zielordner

// 2. Nextcloud (WebDAV) Einstellungen
$NC_URL    = 'https://cloud.zusatzalarmbz.de/remote.php/dav/files/SchriftfuehrerBZ';
$NC_USER   = 'schriftfuehrer@feuerwehr-bad-zwischenahn.de';
$NC_PASS   = 'A2BZ112!!!!'; // ⚠️ Tipp: Nutzen Sie in Zukunft am besten ein "App-Passwort" in Nextcloud
$NC_FOLDER = 'Backup/Software/F-Invent'; // Zielordner in der Cloud

// ==========================================
// 📦 TEIL 1: ZIP-ARCHIV ERSTELLEN
// ==========================================

// Dateiname generieren
$date = date('Y-m-d_H-i-s');
$filename = 'backup_' . $date . '.zip';
$zipFilePath = $backupFolder . '/' . $filename;

// Backup-Ordner erstellen, falls nicht vorhanden
if (!file_exists($backupFolder)) {
    mkdir($backupFolder, 0775, true);
}

echo "⏳ Starte ZIP-Erstellung...\n";

$zip = new ZipArchive();
if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($sourceFolder, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::LEAVES_ONLY
    );

    foreach ($files as $file) {
        if (!$file->isDir()) {
            $filePath = $file->getRealPath();
            $relativePath = substr($filePath, strlen($sourceFolder) + 1);
            $zip->addFile($filePath, $relativePath);
        }
    }

    $zip->close();
    echo "✅ ZIP lokal erstellt: " . $filename . "\n";
} else {
    die("❌ Fehler beim Erstellen der ZIP-Datei.\n");
}

// ==========================================
// ☁️ TEIL 2: UPLOAD ZUR NEXTCLOUD (WebDAV)
// ==========================================

echo "⏳ Starte Upload zu Nextcloud...\n";

// 1. Ziel-URL zusammenbauen (vermeidet doppelte Slashes)
// Format: BASE_URL / ORDNER / DATEINAME
// Leerzeichen in Pfaden müssen für URLs kodiert werden (rawurlencode), falls vorhanden
$uploadUrl = rtrim($NC_URL, '/') . '/' . trim($NC_FOLDER, '/') . '/' . rawurlencode($filename);

// 2. Datei zum Lesen öffnen
$fileHandle = fopen($zipFilePath, 'r');
if (!$fileHandle) {
    die("❌ Konnte lokale ZIP-Datei nicht lesen.\n");
}

// 3. cURL Initialisierung
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $uploadUrl);
curl_setopt($ch, CURLOPT_USERPWD, "$NC_USER:$NC_PASS");
curl_setopt($ch, CURLOPT_PUT, true); // Wichtig für Datei-Upload
curl_setopt($ch, CURLOPT_INFILE, $fileHandle);
curl_setopt($ch, CURLOPT_INFILESIZE, filesize($zipFilePath));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_BINARYTRANSFER, true); // Sicherstellen, dass binär übertragen wird

// Optional: SSL-Prüfung deaktivieren, falls Zertifikatsprobleme auftreten (nicht empfohlen für Prod)
// curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

// 4. Ausführen
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);

curl_close($ch);
fclose($fileHandle);

// ==========================================
// 🏁 STATUS PRÜFEN
// ==========================================

// WebDAV gibt meist 201 (Created) oder 204 (No Content) zurück
if ($httpCode >= 200 && $httpCode < 300) {
    echo "✅ Upload erfolgreich! (HTTP Code: $httpCode)\n";
    echo "📍 Gespeichert unter: $NC_FOLDER/$filename\n";

    // Optional: Lokale Datei nach Upload löschen, um Speicher zu sparen
    // unlink($zipFilePath);
    // echo "🗑️ Lokale Datei bereinigt.\n";
} else {
    echo "❌ Fehler beim Upload.\n";
    echo "➡️ HTTP Status: $httpCode\n";
    echo "➡️ cURL Fehler: $curlError\n";
    echo "➡️ Server Antwort: $response\n";
}
?>
