<?php
// lernapp_fahrzeuge.php – Geräte-Lernansicht je Fahrzeug mit Swipe (nur Einheit A2BZ)

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// -------------------- DB-Verbindung direkt hier --------------------
$host = 'localhost';
$user = 'kd54698_cloud';
$pass = 'w3r24asd!!!';
$db   = 'kd54698_cloud';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Verbindung fehlgeschlagen: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

// Bildpfad (Hochkant-Bilder liegen hier)
$imgBaseUrl = '../lernapp/uploads/geraete/';

// Einheit fest definiert
$fixedEinheit = 'A2BZ';

// -------------------- Fahrzeug-Auswahl --------------------
$vehicleId = isset($_GET['vehicle_id']) ? (int)$_GET['vehicle_id'] : 0;

// Fahrzeuge holen – NUR A2BZ
$sqlV = "
    SELECT id, fahrzeugname, fahrzeugbezeichnung, fahrzeugkurz,
           kennzeichen, funkrufname, barcode_fzg, einheit
    FROM ffw_fahrzeuge
    WHERE einheit = '".$conn->real_escape_string($fixedEinheit)."'
    ORDER BY fahrzeugbezeichnung ASC
";

$vehicles = [];
$resV = $conn->query($sqlV);
while ($row = $resV->fetch_assoc()) {
    $vehicles[] = $row;
}

// -------------------- Geräte für gewähltes Fahrzeug --------------------
$currentVehicle = null;
$devices = [];

if ($vehicleId > 0) {
    // Fahrzeug laden, ebenfalls nur aus A2BZ
    $stmtV = $conn->prepare("
        SELECT id, fahrzeugname, fahrzeugbezeichnung, fahrzeugkurz,
               kennzeichen, funkrufname, barcode_fzg, einheit
        FROM ffw_fahrzeuge
        WHERE id = ?
          AND einheit = ?
        LIMIT 1
    ");
    $stmtV->bind_param('is', $vehicleId, $fixedEinheit);
    $stmtV->execute();
    $currentVehicle = $stmtV->get_result()->fetch_assoc();
    $stmtV->close();

    if ($currentVehicle) {
        // Geräte zu diesem Fahrzeug:
        // Nur Geräte mit Bild (kein "kein-bild.svg")
        $stmtG = $conn->prepare("
            SELECT g.id,
                   g.bezeichnung,
                   g.memo,
                   g.bild,
                   g.gr,
                   g.kat,
                   g.status
            FROM ffw_geraete g
            JOIN ffw_fahrzeuge f
              ON f.barcode_fzg = g.fahrzeug
             AND f.einheit     = g.einheit
            WHERE f.id = ?
              AND f.einheit = ?
              AND g.del = 0
              AND (g.status IS NULL OR g.status <> 'Ausgesondert')
              AND g.bild IS NOT NULL
              AND g.bild <> ''
              AND g.bild <> 'kein-bild.svg'
            ORDER BY g.gr ASC, g.bezeichnung ASC
        ");
        $stmtG->bind_param('is', $vehicleId, $fixedEinheit);
        $stmtG->execute();
        $resG = $stmtG->get_result();
        while ($r = $resG->fetch_assoc()) {
            $devices[] = $r;
        }
        $stmtG->close();
    }
}
?>
<!doctype html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <title>Geräte-Lernapp – Feuerwehr</title>
  <!-- Favicon -->
<link rel="icon" type="image/x-icon" href="favicon.ico">

<!-- Optional: zusätzliche PNG-Icons -->
<link rel="icon" type="image/png" sizes="32x32" href="favicon-32x32.png">
<link rel="apple-touch-icon" sizes="180x180" href="apple-touch-icon.png">
<link rel="icon" type="image/x-icon" href="feuerwehr_lernapp_favicon.ico">
<link rel="apple-touch-icon" sizes="180x180" href="feuerwehr_lernapp_icon_512.png">


  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap + Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    :root {
      --fw-red: #ff3b30;
      --fw-orange: #ff9500;
      --fw-dark: #05070b;
      --fw-card-bg: rgba(11, 15, 25, 0.96);
      --fw-border-soft: rgba(255,255,255,0.05);
    }

    body {
      background: radial-gradient(circle at top, #1b2435 0, #05070b 55%, #020308 100%);
      min-height: 100vh;
      margin: 0;
      color: #f5f5f5;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }

    .page-container {
      max-width: 960px;
      margin: 0 auto;
      padding: 0.75rem 0.75rem 1rem;
    }

    /* Header / Appbar */
    .app-header {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 0.75rem 0.25rem 0.5rem;
      position: sticky;
      top: 0;
      z-index: 20;
      background: linear-gradient(to bottom, rgba(5,7,11,0.96), rgba(5,7,11,0.92), transparent);
      backdrop-filter: blur(16px);
    }

    .app-title {
      display: flex;
      align-items: center;
      gap: 0.6rem;
    }

    .app-icon {
      width: 36px;
      height: 36px;
      border-radius: 12px;
      background: radial-gradient(circle at 30% 0, #ffd4c4 0, #ff3b30 35%, #d60000 65%, #540000 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow:
        0 0 0 1px rgba(255,255,255,0.12),
        0 10px 25px rgba(0,0,0,0.6);
    }

    .app-icon i {
      font-size: 1.3rem;
      color: #fff;
    }

    .app-title-main {
      font-weight: 700;
      font-size: 1.1rem;
      letter-spacing: 0.04em;
      text-transform: uppercase;
    }

    .app-title-sub {
      font-size: 0.75rem;
      color: rgba(255,255,255,0.65);
    }

    .app-badge {
      font-size: 0.7rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      padding: 0.25rem 0.5rem;
      border-radius: 999px;
      border: 1px solid rgba(255,255,255,0.2);
      background: radial-gradient(circle at 0 0, rgba(255,149,0,0.6), rgba(255,59,48,0.15));
      color: #ffe9d2;
      white-space: nowrap;
    }

    /* Fahrzeug-Auswahl */
    .vehicle-list-title {
      font-size: 0.9rem;
      color: rgba(255,255,255,0.7);
      margin-bottom: 0.3rem;
      margin-top: 0.3rem;
    }

    .vehicle-chip {
      border-radius: 16px;
      padding: 0.7rem 0.9rem;
      margin: 0.25rem 0;
      font-size: 0.9rem;
      border: 1px solid var(--fw-border-soft);
      background: linear-gradient(135deg, rgba(15,19,33,0.98), rgba(13,16,28,0.96));
      box-shadow: 0 8px 24px rgba(0,0,0,0.6);
      cursor: pointer;
      transition: transform 0.12s ease, box-shadow 0.12s ease, border-color 0.12s ease, background 0.12s ease;
      display: flex;
      align-items: center;
      justify-content: space-between;
      gap: 0.8rem;
      color: #f7f7f7;
    }

    .vehicle-chip-content {
      display: flex;
      flex-direction: column;
      gap: 0.1rem;
    }

    .vehicle-chip strong {
      font-size: 0.95rem;
    }

    .vehicle-meta-line {
      font-size: 0.75rem;
      color: rgba(255,255,255,0.7);
    }

    .vehicle-chip-tag {
      font-size: 0.7rem;
      padding: 0.15rem 0.5rem;
      border-radius: 999px;
      border: 1px solid rgba(255,255,255,0.18);
      color: rgba(255,255,255,0.85);
    }

    .vehicle-chip.active {
      border-color: rgba(255,149,0,0.8);
      background: radial-gradient(circle at 0 0, rgba(255,149,0,0.5), rgba(15,19,33,0.96));
      box-shadow:
        0 0 0 1px rgba(255,149,0,0.25),
        0 0 35px rgba(255,59,48,0.35);
      transform: translateY(-1px);
    }

    .vehicle-chip:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 26px rgba(0,0,0,0.7);
    }

    /* Hochkant-Karten */
    .swipe-wrapper {
      position: relative;
      overflow: hidden;
      margin-top: 0.75rem;
      height: calc(100vh - 220px); /* fast vollflächig hochkant */
    }

    .device-card {
      position: absolute;
      inset: 0;
      opacity: 0;
      transform: translateX(40px);
      transition: opacity 0.25s ease, transform 0.25s ease;
      pointer-events: none;
    }

    .device-card.active {
      opacity: 1;
      transform: translateX(0);
      pointer-events: auto;
    }

    .device-card.previous {
      opacity: 0;
      transform: translateX(-40px);
    }

    .device-inner {
      background: var(--fw-card-bg);
      border-radius: 22px;
      box-shadow:
        0 18px 45px rgba(0,0,0,0.9),
        0 0 0 1px rgba(255,255,255,0.04);
      backdrop-filter: blur(18px);
      padding: 0.85rem 0.85rem 0.75rem;
      display: flex;
      flex-direction: column;
      height: 100%;
      position: relative;
      overflow: hidden;
    }

    .device-header-bar {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 0.4rem;
      padding-bottom: 0.2rem;
      border-bottom: 1px solid rgba(255,255,255,0.08);
    }

    .device-header-left {
      display: flex;
      flex-direction: column;
      gap: 0.1rem;
    }

    .device-title {
      font-size: 1.05rem;
      font-weight: 700;
    }

    .device-meta-line-header {
      font-size: 0.75rem;
      color: rgba(255,255,255,0.7);
    }

    .device-badge {
      font-size: 0.7rem;
      padding: 0.18rem 0.55rem;
      border-radius: 999px;
      border: 1px solid rgba(255,255,255,0.16);
      background: radial-gradient(circle at 0 0, rgba(255,59,48,0.65), rgba(15,19,33,1));
      color: #ffeae6;
      text-transform: uppercase;
      letter-spacing: 0.08em;
    }

    .device-image-wrap {
      border-radius: 18px;
      overflow: hidden;
      background: radial-gradient(circle at top, rgba(255,149,0,0.14), rgba(21,28,49,1));
      flex: 1 1 auto;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-bottom: 0.6rem;
      position: relative;
    }

    .device-image-wrap::after {
      content: "";
      position: absolute;
      inset: 0;
      background: radial-gradient(circle at 50% 0, rgba(255,255,255,0.2), transparent 55%);
      mix-blend-mode: screen;
      opacity: 0.4;
      pointer-events: none;
    }

    .device-image-wrap img {
      width: 100%;
      height: 100%;
      object-fit: contain;
      position: relative;
      z-index: 1;
    }


    .device-meta {
      font-size: 0.75rem;
      color: rgba(255,255,255,0.7);
      margin-bottom: 0.25rem;
    }

    .meta-pill {
      display: inline-flex;
      align-items: center;
      gap: 0.3rem;
      padding: 0.15rem 0.5rem;
      border-radius: 999px;
      background: rgba(255,255,255,0.03);
      border: 1px solid rgba(255,255,255,0.12);
      font-size: 0.72rem;
      margin-right: 0.25rem;
      margin-bottom: 0.1rem;
    }

    .meta-pill i {
      font-size: 0.72rem;
      color: rgba(255,255,255,0.9);
    }

    .device-desc {
      font-size: 0.86rem;
      white-space: pre-line;
      color: rgba(255,255,255,0.86);
    }

    /* Navigation unten */
    .nav-bar {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-top: 0.4rem;
      gap: 0.75rem;
      flex-wrap: wrap;
    }

    .nav-buttons {
      display: flex;
      align-items: center;
      gap: 0.4rem;
      flex: 1 1 auto;
    }

    .btn-fw {
      border-radius: 999px;
      border: none;
      padding: 0.45rem 0.9rem;
      font-size: 0.85rem;
      font-weight: 600;
      display: inline-flex;
      align-items: center;
      gap: 0.35rem;
      text-transform: uppercase;
      letter-spacing: 0.06em;
      background: linear-gradient(135deg, #ff3b30, #ff9500);
      color: #fff;
      box-shadow:
        0 0 0 1px rgba(255,255,255,0.08),
        0 10px 26px rgba(0,0,0,0.9);
    }

    .btn-fw-secondary {
      background: linear-gradient(135deg, #1d2538, #111522);
      color: rgba(255,255,255,0.9);
    }

    .btn-fw:disabled {
      opacity: 0.45;
      box-shadow: none;
    }

    .nav-info {
      font-size: 0.78rem;
      color: rgba(255,255,255,0.65);
      white-space: nowrap;
    }

    .nav-dots {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 0.25rem;
      margin-top: 0.25rem;
      flex-basis: 100%;
    }

    .dot {
      width: 6px;
      height: 6px;
      border-radius: 999px;
      background: rgba(255,255,255,0.18);
      transition: transform 0.15s ease, background-color 0.15s ease, width 0.15s ease;
    }

    .dot.active {
      width: 16px;
      background: linear-gradient(135deg, #ff9500, #ff3b30);
      transform: translateY(-1px);
    }

    @media (max-width: 768px) {
      .page-container {
        padding: 0.4rem 0.55rem 0.9rem;
      }
      .swipe-wrapper {
        height: calc(100vh - 210px);
      }
      .app-title-main {
        font-size: 1.0rem;
      }
      .device-inner {
        border-radius: 20px;
      }
      .btn-fw {
        padding-inline: 0.7rem;
      }
    }
  </style>
</head>
<body>

<div class="page-container">

  <header class="app-header">
    <div class="app-title">
      <div class="app-icon">
        <i class="bi bi-fire"></i>
      </div>
      <div>
        <div class="app-title-main">Geräte Lernapp</div>
        <div class="app-title-sub">Einheit <?= h($fixedEinheit) ?> · Fahrzeug &amp; Geräte</div>
      </div>
    </div>
    <div class="app-badge">
      <i class="bi bi-lightning-charge-fill me-1"></i>Training
    </div>
  </header>

  <?php if (!$currentVehicle): ?>
    <!-- Schritt 1: Fahrzeug wählen -->
    <div class="mt-2 mb-2 vehicle-list-title">
      Fahrzeug auswählen und danach durch die Geräte wischen.
    </div>

    <?php if (empty($vehicles)): ?>
      <div class="alert alert-warning">
        Keine Fahrzeuge für Einheit <code><?= h($fixedEinheit) ?></code> gefunden.
      </div>
    <?php else: ?>
      <div class="vehicle-list">
        <?php foreach ($vehicles as $v): ?>
          <a href="?vehicle_id=<?= (int)$v['id'] ?>" class="text-decoration-none d-block">
            <div class="vehicle-chip<?= ($vehicleId === (int)$v['id']) ? ' active' : '' ?>">
              <div class="vehicle-chip-content">
                <strong><?= h($v['fahrzeugbezeichnung'] ?: $v['fahrzeugname']) ?></strong>
                <div class="vehicle-meta-line">
                  <?php if (!empty($v['funkrufname'])): ?>
                    <i class="bi bi-broadcast-pin me-1"></i><?= h($v['funkrufname']) ?>
                  <?php endif; ?>
                  <?php if (!empty($v['kennzeichen'])): ?>
                    <?php if (!empty($v['funkrufname'])): ?> · <?php endif; ?>
                    <i class="bi bi-truck-front me-1"></i><?= h($v['kennzeichen']) ?>
                  <?php endif; ?>
                </div>
              </div>
              <div class="vehicle-chip-tag">
                <i class="bi bi-chevron-right"></i> Lernen
              </div>
            </div>
          </a>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

    <div class="mt-3 text-center" style="font-size:0.75rem; color:rgba(255,255,255,0.6);">
      Tipp: Diese Seite als Icon auf den Homescreen legen – dann fühlt es sich wie eine echte App an.
    </div>

  <?php else: ?>
    <!-- Schritt 2: Lernansicht -->
    <div class="mt-1 mb-2">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div style="font-size:0.8rem; color:rgba(255,255,255,0.6); text-transform:uppercase; letter-spacing:0.08em;">
            Fahrzeug
          </div>
          <h2 class="h6 mb-0">
            <?= h($currentVehicle['fahrzeugbezeichnung'] ?: $currentVehicle['fahrzeugname']) ?>
          </h2>
          <div class="small" style="color:rgba(255,255,255,0.7);">
            Einheit: <?= h($currentVehicle['einheit']) ?>
            <?php if (!empty($currentVehicle['funkrufname'])): ?>
              · <i class="bi bi-broadcast-pin me-1"></i><?= h($currentVehicle['funkrufname']) ?>
            <?php endif; ?>
            <?php if (!empty($currentVehicle['kennzeichen'])): ?>
              · <i class="bi bi-truck-front me-1"></i><?= h($currentVehicle['kennzeichen']) ?>
            <?php endif; ?>
          </div>
        </div>
        <div class="text-end">
          <a href="index.php" class="btn btn-sm btn-outline-light" style="border-radius:999px;">
            <i class="bi bi-arrow-left-short"></i> Fahrzeuge
          </a>
        </div>
      </div>
      <div class="text-muted small mt-1" style="color:rgba(255,255,255,0.6)!important;">
        Wischen oder Buttons nutzen, um zwischen den Geräten zu wechseln.
      </div>
    </div>

    <?php if (empty($devices)): ?>
      <div class="alert alert-info">
        Für dieses Fahrzeug wurden noch keine Geräte mit Bild gefunden.
      </div>
    <?php else: ?>
      <div id="swipeArea" class="swipe-wrapper">
        <?php foreach ($devices as $idx => $d): ?>
          <?php
            $imgSrc = $imgBaseUrl . $d['bild']; // ist gesetzt durch SQL-Filter
          ?>
          <div class="device-card<?= $idx === 0 ? ' active' : '' ?>" data-index="<?= $idx ?>">
            <div class="device-inner">
              <div class="device-header-bar">
                <div class="device-header-left">
                  <div class="device-title"><?= h($d['bezeichnung']) ?></div>
                  <div class="device-meta-line-header">
                    Gerät <?= ($idx+1) ?> von <?= count($devices) ?>
                  </div>
                </div>
                <span class="device-badge">
                  <i class="bi bi-mortarboard-fill me-1"></i>Lernen
                </span>
              </div>

              <div class="device-image-wrap mb-2">
                <img src="<?= h($imgSrc) ?>" alt="<?= h($d['bezeichnung']) ?>">
              </div>

              <div>
                <?php if (!empty($d['gr']) || !empty($d['kat'])): ?>
                  <div class="mb-1">
                    <?php if (!empty($d['gr'])): ?>
                      <span class="meta-pill">
                        <i class="bi bi-grid-3x3-gap-fill"></i>
                        GR: <?= h($d['gr']) ?>
                      </span>
                    <?php endif; ?>
                    <?php if (!empty($d['kat'])): ?>
                      <span class="meta-pill">
                        <i class="bi bi-tags-fill"></i>
                        <?= h($d['kat']) ?>
                      </span>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>

                <?php if (!empty($d['memo'])): ?>
                  <div class="device-desc">
                    <?= nl2br(h($d['memo'])) ?>
                  </div>
                <?php endif; ?>
              </div>

            </div>
          </div>
        <?php endforeach; ?>
      </div>

      <div class="nav-bar">
        <div class="nav-buttons">
          <button type="button" class="btn-fw btn-fw-secondary" id="btnPrev">
            <i class="bi bi-chevron-left"></i> Zurück
          </button>
          <button type="button" class="btn-fw" id="btnNext">
            Weiter <i class="bi bi-chevron-right"></i>
          </button>
        </div>
        <div class="nav-info">
          <span id="cardPos">1</span> / <?= count($devices) ?> Geräte
        </div>
        <div class="nav-dots" id="navDots">
          <?php for ($i = 0; $i < count($devices); $i++): ?>
            <span class="dot<?= $i === 0 ? ' active' : '' ?>"></span>
          <?php endfor; ?>
        </div>
      </div>
    <?php endif; ?>
  <?php endif; ?>
</div>

<script>
// Swipe + Buttons + Dots
(function(){
  const cards = document.querySelectorAll('.device-card');
  if (!cards.length) return;

  let current = 0;
  const total = cards.length;
  const posLabel = document.getElementById('cardPos');
  const dots = document.querySelectorAll('#navDots .dot');
  const btnPrev = document.getElementById('btnPrev');
  const btnNext = document.getElementById('btnNext');

  function updateDots() {
    if (!dots.length) return;
    dots.forEach((d, i) => {
      d.classList.toggle('active', i === current);
    });
  }

  function updateButtons() {
    if (!btnPrev || !btnNext) return;
    btnPrev.disabled = (current === 0);
    btnNext.disabled = (current === total - 1);
  }

  function showCard(index) {
    if (index < 0 || index >= total) return;
    cards.forEach((c, i) => {
      c.classList.remove('active', 'previous');
      if (i === index) c.classList.add('active');
      else if (i < index) c.classList.add('previous');
    });
    current = index;
    if (posLabel) posLabel.textContent = (current + 1).toString();
    updateDots();
    updateButtons();
  }

  btnPrev?.addEventListener('click', () => {
    showCard(current - 1);
  });
  btnNext?.addEventListener('click', () => {
    showCard(current + 1);
  });

  const swipeArea = document.getElementById('swipeArea');
  if (swipeArea) {
    let startX = 0;
    let endX = 0;

    swipeArea.addEventListener('touchstart', (e) => {
      const t = e.changedTouches[0];
      startX = t.screenX;
    }, {passive:true});

    swipeArea.addEventListener('touchend', (e) => {
      const t = e.changedTouches[0];
      endX = t.screenX;
      const diff = endX - startX;

      if (Math.abs(diff) > 50) {
        if (diff < 0) {
          showCard(current + 1); // nach links -> nächste Karte
        } else {
          showCard(current - 1); // nach rechts -> vorherige Karte
        }
      }
    }, {passive:true});
  }

  // Keyboard support (am PC)
  window.addEventListener('keydown', (e) => {
    if (e.key === 'ArrowRight') showCard(current + 1);
    if (e.key === 'ArrowLeft')  showCard(current - 1);
  });

  // Initial
  updateDots();
  updateButtons();
})();
</script>

</body>
</html>
