<?php
// lieferschein_details.php – DIN A4 optimiert + Hinweis Feld
session_start();
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_einheit    = $_SESSION['einheit'] ?? '';
$lieferschein_id = (int)($_GET['id'] ?? 0);

if ($lieferschein_id <= 0 || $user_einheit === '') {
    echo "<div class='container mt-5'><div class='alert alert-danger'>Ungültige Anfrage.</div></div>";
    include 'includes/footer.php';
    exit;
}

/* -------------------- Lieferschein laden -------------------- */
// WICHTIG: a.hinweis als adr_hinweis aliasen, damit es nicht mit l.hinweis kollidiert!
$sqlL = "
    SELECT l.*,
           u.vorname, u.nachname,
           a.bezeichnung, a.strasse, a.plz, a.ort,
           a.hinweis AS adr_hinweis
      FROM lieferscheine l
 LEFT JOIN users u    ON l.erstellt_von = u.id
 LEFT JOIN adressen a ON l.adresse_id = a.id
     WHERE l.id = ? AND l.einheit = ?
";
$stmt = $conn->prepare($sqlL);
$stmt->bind_param("is", $lieferschein_id, $user_einheit);
$stmt->execute();
$lieferschein = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$lieferschein) {
    echo "<div class='container mt-5'><div class='alert alert-danger'>Lieferschein nicht gefunden.</div></div>";
    include 'includes/footer.php'; exit;
}

/* -------------------- Geräte laden -------------------- */
$sqlG = "
    SELECT g.bezeichnung, g.barcode, f.fahrzeugname, g.kat, g.gr
      FROM lieferschein_geraete lg
      JOIN ffw_geraete g         ON lg.geraet_id = g.id
 LEFT JOIN ffw_fahrzeuge f       ON g.fahrzeug = f.barcode_fzg
     WHERE lg.lieferschein_id = ?
  ORDER BY f.fahrzeugname ASC, g.bezeichnung ASC
";
$stG = $conn->prepare($sqlG);
$stG->bind_param("i", $lieferschein_id);
$stG->execute();
$geraete = $stG->get_result()->fetch_all(MYSQLI_ASSOC);
$stG->close();

/* -------------------- Positionen laden -------------------- */
$sqlP = "SELECT bezeichnung, menge, bemerkung FROM lieferschein_positionen WHERE lieferschein_id = ? ORDER BY id ASC";
$stP = $conn->prepare($sqlP);
$stP->bind_param("i", $lieferschein_id);
$stP->execute();
$positionen = $stP->get_result()->fetch_all(MYSQLI_ASSOC);
$stP->close();

/* -------------------- Helper & Daten -------------------- */
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$anzGeraete    = count($geraete);
$anzPositionen = count($positionen);
$lieferdatum   = $lieferschein['lieferdatum'] ? date('d.m.Y', strtotime($lieferschein['lieferdatum'])) : date('d.m.Y');
$erstelltDatum = $lieferschein['erstellt_am'] ? date('d.m.Y', strtotime($lieferschein['erstellt_am'])) : date('d.m.Y');
?>

<style>
    :root {
        --print-font: "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        --print-black: #000;
        --print-gray: #555;
        --print-border: #ccc;
    }

    body {
        background-color: #e9ecef;
        font-family: var(--print-font);
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    .sheet {
        background: white;
        width: 210mm;
        min-height: 297mm;
        margin: 20px auto;
        padding: 20mm;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        position: relative;
        color: var(--print-black);
    }

    /* Header */
    .header-row {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 10mm;
        border-bottom: 2px solid var(--print-black);
        padding-bottom: 5mm;
    }

    .company-logo h2 { margin: 0; font-weight: 800; letter-spacing: -1px; }

    /* Adressfeld */
    .address-field {
        float: left;
        width: 85mm;
        height: 40mm;
        font-size: 11pt;
        line-height: 1.4;
        margin-top: 10mm;
        margin-bottom: 5mm;
    }
    .sender-small {
        font-size: 8pt;
        text-decoration: underline;
        margin-bottom: 5px;
        color: var(--print-gray);
    }

    /* Info Block Rechts */
    .info-block {
        float: right;
        width: 70mm;
        margin-top: 10mm;
        font-size: 10pt;
    }
    .info-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 4px;
    }
    .info-label { font-weight: bold; }

    .document-title {
        clear: both;
        font-size: 20pt;
        font-weight: 800;
        text-transform: uppercase;
        margin-top: 55mm;
        margin-bottom: 5mm;
        letter-spacing: 1px;
    }

    .intro-text {
        margin-bottom: 5mm;
        font-size: 10pt;
    }

    /* --- HINWEIS BOX (NEU) --- */
    .notice-box {
        border: 2px solid #000; /* Dickerer Rahmen für Aufmerksamkeit */
        padding: 10px 15px;
        margin-bottom: 10mm;
        font-size: 10pt;
        background-color: #f8f9fa; /* Leichtes Grau, druckt meist gut */
        border-radius: 4px;
    }
    .notice-title {
        font-weight: bold;
        text-transform: uppercase;
        font-size: 9pt;
        margin-bottom: 4px;
        display: block;
    }

    /* Tabellen */
    .print-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 10mm;
        font-size: 10pt;
    }
    .print-table th {
        border-bottom: 2px solid var(--print-black);
        text-align: left;
        padding: 6px;
        font-weight: 700;
        text-transform: uppercase;
        font-size: 9pt;
    }
    .print-table td {
        border-bottom: 1px solid var(--print-border);
        padding: 6px;
        vertical-align: top;
    }
    .print-table tr:nth-child(even) { background-color: #fcfcfc; }

    /* Footer */
    .signature-area {
        margin-top: 20mm;
        display: flex;
        justify-content: space-between;
        page-break-inside: avoid;
    }
    .sign-box {
        width: 45%;
        border-top: 1px solid var(--print-black);
        padding-top: 5px;
        font-size: 9pt;
        text-align: center;
    }

    /* Screen Controls */
    .screen-controls {
        width: 210mm;
        margin: 20px auto 0;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    @media print {
        @page { size: A4; margin: 0; }
        body, html { background: white; margin: 0; width: 100%; height: 100%; }
        .navbar, footer, .screen-controls, .alert, .no-print { display: none !important; }
        .sheet { width: 100%; margin: 0; box-shadow: none; border: none; padding: 20mm; }
        .print-table tr { page-break-inside: avoid; }
        .print-table thead { display: table-header-group; }
        a { text-decoration: none; color: black; }
        /* Hintergrunddruck erzwingen für die Hinweisbox (Browser-abhängig) */
        .notice-box { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
    }
</style>

<div class="screen-controls no-print">
    <a href="lieferschein_liste.php" class="btn btn-secondary">&laquo; Zur Übersicht</a>
    <div>
        <span class="text-muted me-3 small">Vorschau DIN A4</span>
        <button onclick="window.print()" class="btn btn-primary fw-bold">
            <i class="bi bi-printer-fill me-2"></i> Drucken
        </button>
    </div>
</div>

<div class="sheet">

    <div class="header-row">
        <div class="company-logo">
          <img src="../img/logo2.png" height="150px" width="150px">
            <div style="font-size:9pt; margin-top:5px;">Feuerwehr Inventarverwaltung</div>
        </div>
        <div style="text-align:right; font-size:9pt;">
            <strong>Freiwillige Feuerwehr</strong><br>
            Einheit <?= h($user_einheit) ?><br>
            Vor dem Esch 11-13<br>
            26160 Bad Zwischenahn
        </div>
    </div>

    <div class="address-field">


        <strong><?= h($lieferschein['empfaenger'] ?: 'Empfänger') ?></strong><br>
        <?php if(!empty($lieferschein['bezeichnung'])): ?>
            <?= h($lieferschein['bezeichnung']) ?><br>
        <?php endif; ?>
        <?php if(!empty($lieferschein['strasse'])): ?>
            <?= h($lieferschein['strasse']) ?><br>
        <?php endif; ?>
        <?= h(trim(($lieferschein['plz'] ?? '').' '.($lieferschein['ort'] ?? ''))) ?>
    </div>

    <div class="info-block">
        <div class="info-row">
            <span class="info-label">Lieferschein Nr.:</span>
            <span><?= (int)$lieferschein_id ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Datum:</span>
            <span><?= h($lieferdatum) ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Kunden-Nr.:</span>
            <span><?= (int)($lieferschein['adresse_id'] ?? 0) ?></span>
        </div>
        <br>
        <div class="info-row">
            <span class="info-label">Bearbeiter:</span>
            <span><?= h(substr(($lieferschein['vorname']??''),0,1).'. '.($lieferschein['nachname']??'')) ?></span>
        </div>
    </div>

    <div class="document-title">Lieferschein</div>

    <div class="intro-text">
        Sehr geehrte Damen und Herren,<br>
        folgende Positionen liefern wir Ihnen gemäß Ihrer Anforderung:
    </div>

    <?php if (!empty($lieferschein['hinweis'])): ?>
        <div class="notice-box">
            <span class="notice-title">ℹ️ Hinweis / Bemerkung:</span>
            <?= nl2br(h($lieferschein['hinweis'])) ?>
        </div>
    <?php endif; ?>

    <?php if ($anzGeraete > 0): ?>
        <table class="print-table">
            <thead>
                <tr>
                    <th style="width: 5%;">Pos.</th>
                    <th style="width: 50%;">Bezeichnung / Gerät</th>
                    <th style="width: 25%;">Inventar-Nr.</th>
                    <th style="width: 20%;">Herkunft</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($geraete as $i => $g): ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td>
                        <strong><?= h($g['bezeichnung']) ?></strong><br>
                        <span style="font-size:8pt; color:#444;">
                            <?= h($g['kat']) ?> <?= $g['gr'] ? '(GR: '.h($g['gr']).')' : '' ?>
                        </span>
                    </td>
                    <td style="font-family: monospace; font-size:11pt;"><?= h($g['barcode']) ?></td>
                    <td><?= h($g['fahrzeugname'] ?: 'Lager') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

    <?php if ($anzPositionen > 0): ?>
        <?php if ($anzGeraete > 0): ?><div style="margin-top:5mm; font-weight:bold; font-size:10pt;">Zusatzmaterial:</div><?php endif; ?>
        <table class="print-table">
            <thead>
                <tr>
                    <th style="width: 5%;">Pos.</th>
                    <th style="width: 50%;">Artikel / Beschreibung</th>
                    <th style="width: 15%;">Menge</th>
                    <th style="width: 30%;">Bemerkung</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($positionen as $j => $p): ?>
                <tr>
                    <td><?= ($anzGeraete + $j + 1) ?></td>
                    <td><?= h($p['bezeichnung']) ?></td>
                    <td><?= h($p['menge']) ?></td>
                    <td><?= h($p['bemerkung']) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

    <?php if (!empty($lieferschein['adr_hinweis'])): ?>
        <div style="font-size:9pt; color:#555; margin-top:5mm; border-top:1px dashed #ccc; padding-top:2mm;">
            <em>Info zur Lieferadresse: <?= h($lieferschein['adr_hinweis']) ?></em>
        </div>
    <?php endif; ?>

    <div style="margin-top: 15mm;">
        <p style="font-size: 9pt;">Bitte prüfen Sie die Ware sofort auf Vollständigkeit und Unversehrtheit.</p>
    </div>

    <div class="signature-area">
        <div class="sign-box">
            <br><br>
            Erstellt am <?= h($erstelltDatum) ?><br>
            (Ausgabe)
        </div>
        <div class="sign-box">
            <br><br>
            Ware vollständig erhalten<br>
            (Datum / Unterschrift Empfänger)
        </div>
    </div>

</div>

<?php include 'includes/footer.php'; ?>
