<?php
// Annahme: $conn (DB) und $bestellte_artikel sind bereits über include verfügbar

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
include_once __DIR__ . '/PHPMailer/PHProcksAutoloader.php';

$subject = "📦 Neue Bestellung";

// Nachricht vorbereiten
$nachricht = "Folgende Artikel wurden neu bestellt:\n\n";
$nachricht .= sprintf("%-15s %-35s %-10s %8s\n", "Artikelnummer", "Artikelname", "Größe", "Anzahl");

foreach ($bestellte_artikel as $artikel) {
    $artikelnummer = '-';

    // Artikelnummer aus DB holen, falls Artikelname bekannt
    if (!empty($artikel['artikelname'])) {
        $stmt = $conn->prepare("SELECT artikelnummer FROM lager_bestand WHERE artikelname = ? LIMIT 1");
        $stmt->bind_param("s", $artikel['artikelname']);
        $stmt->execute();
        $stmt->bind_result($ergebnis);
        if ($stmt->fetch()) {
            $artikelnummer = $ergebnis;
        }
        $stmt->close();
    }

    $nachricht .= sprintf(
        "%-15s %-35s %-10s %8s\n",
        $artikelnummer,
        mb_strimwidth($artikel['artikelname'], 0, 34, "..."),
        $artikel['groesse'],
        $artikel['anzahl']
    );
}

$nachricht_html = "<pre>" . htmlspecialchars($nachricht) . "</pre>";


$html = <<<HTML
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Neue Bestellung</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      padding: 20px;
    }
    .container {
      max-width: 900px;
      margin: 0 auto;
      background: #ffffff;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    .header {
      background: #198754;
      color: #fff;
      padding: 15px;
      font-size: 20px;
      font-weight: bold;
      text-align: center;
      border-radius: 10px 10px 0 0;
    }
    .content {
      padding: 20px;
      font-size: 16px;
      color: #333;
    }
    pre {
      background: #f8f9fa;
      padding: 10px;
      border-radius: 6px;
      font-family: monospace;
      overflow-x: auto;
      white-space: pre;
      width: 100%;
      display: block;
    }
    .footer {
      margin-top: 20px;
      font-size: 14px;
      color: #888;
      text-align: center;
    }
  </style>

</head>
<body>
  <div class="container">
    <div class="header">📦 Neue Bestellung</div>
    <div class="content">
      <p>Moin,</p>
      <p>es wurde soeben eine neue Bestellung ausgelöst. Hier sind die Details:</p>
      $nachricht_html
      <p>Bitte prüfe die Bestellung und veranlasse ggf. die Weiterbearbeitung oder Beschaffung.</p>
      <p>Mit kameradschaftlichen Grüßen</p>
    </div>
    <div class="footer">&copy; app.f-invent.de</div>
  </div>
</body>
</html>
HTML;

$oMailer = new PHPMailer;
$oMailer->CharSet = 'UTF-8';

$oMailer->isSMTP();
$oMailer->Host = 'mail.f-invent.de';
$oMailer->SMTPAuth = true;
$oMailer->Username = 'noreply@f-invent.de';
$oMailer->Password = 'b*Y!@Ys.aKS^';
$oMailer->SMTPSecure = 'tls';
$oMailer->Port = 587;

$oMailer->From = 'noreply@f-invent.de';
$oMailer->FromName = 'app.F-Invent.de';
$oMailer->addAddress('geraeteverwaltung@feuerwehr-bad-zwischenahn.de');
$oMailer->addBCC('ticketsystem@app.f-invent.de');
$oMailer->addReplyTo('ticketsystem@app.f-invent.de');

$oMailer->isHTML(true);
$oMailer->Subject = $subject;
$oMailer->Body = $html;
$oMailer->AltBody = strip_tags($nachricht);

if (!$oMailer->send()) {
    echo '❌ Fehler beim Versand der E-Mail!';
}
?>
