<?php
// Annahme: $conn, $titel, $beschreibung, $faellig_am, $empfaenger_email, $ersteller_name usw. sind bereits gesetzt

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
include_once __DIR__ . '/PHPMailer/PHProcksAutoloader.php';

// Hinweis-Textblock für AltBody und HTML-Pre
$nachricht = "Du hast eine neue Aufgabe erhalten:\n\n";
$nachricht .= sprintf("%-15s %-35s\n", "Feld", "Wert");
$nachricht .= str_repeat("-", 50) . "\n";
$nachricht .= sprintf("%-15s %-35s\n", "Titel:", $titel);
$nachricht .= sprintf("%-15s %-35s\n", "Beschreibung:", $beschreibung);
$nachricht .= sprintf("%-15s %-35s\n", "Fällig am:", $faellig_am);
$nachricht .= sprintf("%-15s %-35s\n", "Erstellt von:", $ersteller_name);

$nachricht_html = "<pre>" . htmlspecialchars($nachricht) . "</pre>";

// HTML-Mail
$html = <<<HTML
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      padding: 20px;
    }
    .container {
      max-width: 900px;
      margin: 0 auto;
      background: #ffffff;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    .header {
      background: #198754;
      color: #fff;
      padding: 15px;
      font-size: 20px;
      font-weight: bold;
      text-align: center;
      border-radius: 10px 10px 0 0;
    }
    .content {
      padding: 20px;
      font-size: 16px;
      color: #333;
    }
    pre {
      background: #f8f9fa;
      padding: 10px;
      border-radius: 6px;
      font-family: monospace;
      overflow-x: auto;
      white-space: pre;
      width: 100%;
      display: block;
    }
    .footer {
      margin-top: 20px;
      font-size: 14px;
      color: #888;
      text-align: center;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">Neue Aufgabe erhalten</div>
    <div class="content">
      <p>Moin,</p>
      <p>du hast soeben eine neue Aufgabe von <strong>{$ersteller_name}</strong> erhalten.</p>
      {$nachricht_html}
      <p>Bitte logge dich ein, um die Aufgabe zu bearbeiten:</p>
      <p><a href="https://cloud.f-invent.de/aufgaben/">➡️ Zur Aufgabenübersicht</a></p>
    </div>
    <div class="footer">&copy; cloud.F-Invent.de</div>
  </div>
</body>
</html>
HTML;

// Mail versenden
$oMailer = new PHPMailer;
$oMailer->CharSet = 'UTF-8';
$oMailer->isSMTP();
$oMailer->Host = 'mail.f-invent.de';
$oMailer->SMTPAuth = true;
$oMailer->Username = 'noreply@f-invent.de';
$oMailer->Password = 'b*Y!@Ys.aKS^';
$oMailer->SMTPSecure = 'tls';
$oMailer->Port = 587;

$oMailer->From = 'noreply@f-invent.de';
$oMailer->FromName = 'cloud.F-Invent.de';
$oMailer->addAddress($email_empfaenger); // Empfänger der Aufgabe
$oMailer->addReplyTo('aufgaben@app.f-invent.de');

$oMailer->isHTML(true);
$oMailer->Subject = "📌 Neue Aufgabe: $titel";
$oMailer->Body    = $html;
$oMailer->AltBody = strip_tags($nachricht);

if (!$oMailer->send()) {
    echo '❌ Fehler beim Versand der Aufgaben-E-Mail!';
} else {
    echo '✅ Aufgaben-Hinweis wurde erfolgreich per Mail gesendet.';
}
?>
