// sw.js
self.addEventListener('install', (e) => {
  e.waitUntil(
    caches.open('fw-inventar-v1').then((cache) => {
      return cache.addAll([
        'mobile_app.php',
        'manifest.json',
        'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css',
        'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css',
        'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js'
      ]);
    })
  );
});

self.addEventListener('fetch', (e) => {
  // Einfache Strategie: Network first, fallback to cache
  e.respondWith(
    fetch(e.request).catch(() => caches.match(e.request))
  );
});
