<?php
ob_start();
session_start();
include 'includes/db.php';

$meldung = '';
$rfid_eingabe = '';
$erfolg = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rfid = trim($_POST['rfid'] ?? '');
    $rfid_eingabe = ''; // Eingabe nach Verarbeitung leeren

    if ($rfid) {
        $stmt = $conn->prepare("SELECT id, vorname, nachname FROM users WHERE rfid_card = ?");
        $stmt->bind_param("s", $rfid);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();

        if ($user) {
            $user_id = (int)$user['id'];
            $vorname = $user['vorname'];
            $nachname = $user['nachname'];

            // Letzten offenen Eintrag prüfen
            $stmt = $conn->prepare("SELECT * FROM zeiterfassung WHERE kamerad_id = ? AND endzeit IS NULL ORDER BY startzeit DESC LIMIT 1");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $offen = $stmt->get_result()->fetch_assoc();

            if ($offen) {
                $stmt = $conn->prepare("UPDATE zeiterfassung SET endzeit = NOW() WHERE id = ?");
                $stmt->bind_param("i", $offen['id']);
                $stmt->execute();
                $meldung = "<div class='alert alert-danger text-center'><strong>$vorname $nachname</strong> hat sich <strong>ausgeloggt</strong>.</div>";
            } else {
                $standard_kostenstelle = 1;
                $stmt = $conn->prepare("INSERT INTO zeiterfassung (kamerad_id, startzeit, kostenstelle_id) VALUES (?, NOW(), ?)");
                $stmt->bind_param("ii", $user_id, $standard_kostenstelle);
                $stmt->execute();
                $meldung = "<div class='alert alert-success text-center'><strong>$vorname $nachname</strong> hat sich <strong>eingeloggt</strong>.</div>";
            }

            // Link zur persönlichen Zeitanzeige
            $meldung .= "<div class='mt-3 text-center'>
                <a href='zeiten.php?rfid=" . urlencode($rfid) . "' class='btn btn-outline-primary'>🕒 Zeiten anzeigen</a>
            </div>";

            $erfolg = true;
        } else {
            $meldung = "<div class='alert alert-warning text-center'>Unbekannte RFID-Karte.</div>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <title>Zeiterfassung Terminal</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f8f9fa;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }
    .terminal-box {
      max-width: 500px;
      width: 100%;
      padding: 2rem;
      background: white;
      border-radius: 1rem;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    input[type="text"] {
      font-size: 2rem;
      text-align: center;
    }
  </style>
</head>
<body>
  <div class="terminal-box text-center">
    <h2 class="mb-4">📛 Zeiterfassung</h2>
    <?= $meldung ?>
    <form method="post" autocomplete="off">
      <input type="text" name="rfid" id="rfid" class="form-control mb-3" placeholder="RFID scannen..." value="<?= $rfid_eingabe ?>" autofocus>
      <button class="btn btn-primary btn-lg w-100">🆗 Ein-/Ausloggen</button>
    </form>
  </div>

  <audio id="success-sound" src="success.mp3" preload="auto"></audio>

  <script>
    const input = document.getElementById('rfid');
    const sound = document.getElementById('success-sound');

    // Cursor immer im RFID-Feld
    setInterval(() => {
      if (document.activeElement !== input) {
        input.focus();
        input.select();
      }
    }, 1000);

    // Bei Erfolg Ton abspielen
    <?php if ($erfolg): ?>
      sound.play();
    <?php endif; ?>
  </script>
</body>
</html>
<?php ob_end_flush(); ?>
